/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.client.backward_imitate.RenderUtil_1_21_9;
import doggytalents.client.entity.render.RenderUtil;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.CanineTrackerItem;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.CanineTrackerData;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.Util;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class CanineTrackerLocateRenderer {
    private static ResourceLocation DEFAULT_0 = Util.getVanillaResource("default/0");
    private static boolean locating;
    private static UUID locatingUUID;
    private static String locatingName;
    private static BlockPos locatingPos;
    private static int locateColor;
    private static WeakReference<Dog> cachedDog;

    public static void onWorldRenderLast(RenderLevelStageEvent.AfterTranslucentBlocks event) {
        if (!locating) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isSpectator()) {
            return;
        }
        Vec3 dog_pos = null;
        if (cachedDog.get() != null) {
            double d0 = Mth.lerp((double)RenderUtil_1_21_9.getDeltaTracker().getGameTimeDeltaPartialTick(false), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).xOld, (double)((Dog)cachedDog.get()).getX());
            double d1 = Mth.lerp((double)RenderUtil_1_21_9.getDeltaTracker().getGameTimeDeltaPartialTick(false), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).yOld, (double)((Dog)cachedDog.get()).getY());
            double d2 = Mth.lerp((double)RenderUtil_1_21_9.getDeltaTracker().getGameTimeDeltaPartialTick(false), (double)((Dog)CanineTrackerLocateRenderer.cachedDog.get()).zOld, (double)((Dog)cachedDog.get()).getZ());
            dog_pos = new Vec3(d0, d1 + 1.0, d2);
        } else {
            dog_pos = new Vec3((double)locatingPos.getX(), (double)(locatingPos.getY() + 1), (double)locatingPos.getZ());
        }
        CameraRenderState camera = event.getLevelRenderState().cameraRenderState;
        Vec3 camera_pos = camera.pos.add(0.0, -0.2, 0.0);
        Vec3 off_dog_camera = dog_pos.subtract(camera_pos);
        double d_dog_camera = off_dog_camera.length();
        Vec3 off_txt = off_dog_camera;
        if (d_dog_camera > 5.0) {
            off_txt = off_txt.normalize().scale(5.0);
        }
        CanineTrackerLocateRenderer.drawFloatingDistanceText(locatingName, d_dog_camera, off_txt, camera);
    }

    public static void onWorldLogOut() {
        CanineTrackerLocateRenderer.stopLocating();
    }

    public static void drawFloatingDistanceText(String name, double distance, Vec3 off_from_player, CameraRenderState camera) {
        Matrix4f text_mat = new Matrix4f();
        text_mat.translate((float)off_from_player.x(), (float)off_from_player.y(), (float)off_from_player.z());
        text_mat.rotate((Quaternionfc)camera.orientation);
        text_mat.scale(0.02f, -0.02f, 0.02f);
        Font font = Minecraft.getInstance().font;
        Object dog_name = name;
        if (((String)dog_name).length() > 14) {
            dog_name = ((String)dog_name).substring(0, 14) + "..";
        }
        int hl_color = CanineTrackerLocateRenderer.getHighlightColor(distance);
        MutableComponent line1 = Component.translatable((String)"item.doggytalents.radar.locate.line1", (Object[])new Object[]{Component.literal((String)dog_name).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)))});
        MutableComponent line2 = null;
        line2 = distance < 5.0 ? Component.translatable((String)"item.doggytalents.radar.locate.line2.close").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(hl_color)) : Component.translatable((String)"item.doggytalents.radar.locate.line2.far", (Object[])new Object[]{Component.literal((String)("" + Mth.ceil((double)distance))).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(hl_color))});
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        bufferSource.getBuffer(RenderType.text((ResourceLocation)Resources.SMALL_WIDGETS));
        float tX = -font.width((FormattedText)line1) / 2;
        float tY = 0.0f;
        font.drawInBatch((Component)line1, tX, tY, -1, false, text_mat, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        tX = -font.width((FormattedText)line2) / 2;
        Objects.requireNonNull(font);
        font.drawInBatch((Component)line2, tX, tY += (float)(9 + 3), -1, false, text_mat, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        bufferSource.endLastBatch();
    }

    public static int getHighlightColor(double distance) {
        int main_color = locateColor == 0 ? -5586 : locateColor;
        int[] main_color3 = Util.rgbIntToIntArray(main_color);
        if (distance >= 160.0) {
            return -1;
        }
        if ((distance -= 32.0) <= 0.0) {
            return main_color;
        }
        double progress = Mth.clamp((double)((128.0 - distance) / 128.0), (double)0.0, (double)1.0);
        int[] color = new int[]{255, 255, 255};
        color[0] = (int)((double)color[0] + (double)(main_color3[0] - 255) * progress);
        color[1] = (int)((double)color[1] + (double)(main_color3[1] - 255) * progress);
        color[2] = (int)((double)color[2] + (double)(main_color3[2] - 255) * progress);
        return 0xFF000000 | RenderUtil.rgbToInt(color);
    }

    public static void tickUpdate(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            return;
        }
        if (player.tickCount % 4 != 0) {
            return;
        }
        Optional<CompoundTag_1_21_5> tagOptional = CanineTrackerLocateRenderer.getRadarTagIfHoldingAndExist((Player)player);
        if (locating) {
            if (tagOptional.isEmpty()) {
                CanineTrackerLocateRenderer.stopLocating();
                return;
            }
            CompoundTag_1_21_5 tag = tagOptional.get();
            if (!tag.getUUID("uuid").equals(locatingUUID)) {
                CanineTrackerLocateRenderer.setLocating(tag);
            }
            CanineTrackerLocateRenderer.updateCache((Player)player);
            if (player.tickCount % 256 == 0) {
                CanineTrackerLocateRenderer.requestServerForPosUpdate();
            }
        } else {
            if (tagOptional.isEmpty()) {
                return;
            }
            CompoundTag_1_21_5 tag = tagOptional.get();
            CanineTrackerLocateRenderer.setLocating(tag);
        }
    }

    private static void updateCache(Player player) {
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).isRemoved() || !((Dog)cachedDog.get()).getUUID().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
        if (locatingUUID == null || player.tickCount % 8 != 0) {
            return;
        }
        List dogs = player.level().getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(24.0, 8.0, 24.0), dog -> dog.getUUID().equals(locatingUUID));
        if (!dogs.isEmpty()) {
            cachedDog = new WeakReference<Dog>((Dog)dogs.get(0));
        }
    }

    private static Optional<CompoundTag_1_21_5> getRadarTagIfHoldingAndExist(Player player) {
        ItemStack item_main = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack item_off = player.getItemInHand(InteractionHand.OFF_HAND);
        ItemStack radar = null;
        if (item_main.getItem() instanceof CanineTrackerItem) {
            radar = item_main;
        } else if (item_off.getItem() instanceof CanineTrackerItem) {
            radar = item_off;
        }
        if (radar == null) {
            return Optional.empty();
        }
        if (!ItemUtil.hasTag(radar)) {
            return Optional.empty();
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(radar);
        if (tag == null || !tag.hasUUID("uuid")) {
            return Optional.empty();
        }
        return Optional.of(tag);
    }

    private static void requestServerForPosUpdate() {
        if (locatingUUID == null) {
            return;
        }
        if (locatingPos == null) {
            return;
        }
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new CanineTrackerData.RequestPosUpdateData(locatingUUID, locatingPos));
    }

    public static void correctPos(UUID uuid, BlockPos pos) {
        if (!locating) {
            return;
        }
        if (uuid == null) {
            return;
        }
        if (!uuid.equals(locatingUUID)) {
            return;
        }
        locatingPos = pos;
    }

    public static void setLocating(CompoundTag_1_21_5 tag) {
        UUID uuid = tag.getUUID("uuid");
        String name = tag.getString("name");
        int posX = tag.getInt("posX");
        int posY = tag.getInt("posY");
        int posZ = tag.getInt("posZ");
        int color = tag.getInt("locateColor");
        CanineTrackerLocateRenderer.setLocating(uuid, name, new BlockPos(posX, posY, posZ), color);
    }

    public static void setLocating(UUID id, String name, BlockPos pos, int color) {
        if (id == null || name == null || pos == null) {
            return;
        }
        locating = true;
        locatingUUID = id;
        locatingName = name;
        locatingPos = pos;
        locateColor = color;
        if (cachedDog.get() != null && (((Dog)cachedDog.get()).isRemoved() || !((Dog)cachedDog.get()).getUUID().equals(locatingUUID))) {
            cachedDog = new WeakReference<Object>(null);
        }
    }

    public static void stopLocating() {
        locating = false;
        locatingUUID = null;
        locatingName = null;
        locatingPos = null;
        locateColor = 0;
        cachedDog = new WeakReference<Object>(null);
    }

    static {
        cachedDog = new WeakReference<Object>(null);
    }
}

