/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogUntameData;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;

public class DogUntameConfirmScreen
extends Screen {
    Dog dog;

    protected DogUntameConfirmScreen(Dog dog) {
        super((Component)Component.literal((String)""));
        this.dog = dog;
    }

    public static void open(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        DogUntameConfirmScreen screen = new DogUntameConfirmScreen(dog);
        mc.setScreen((Screen)screen);
    }

    protected void init() {
        this.addUntameButton();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        super.render(graphics, mouseX, mouseY, pTicks);
        Matrix3x2fStack stack = graphics.pose();
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        MutableComponent title = Component.translatable((String)"doggui.detrain.confirm.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.detrain.confirm.subtitle", (Object[])new Object[]{this.dog.getName().getString()});
        String dog_title = I18n.get((String)"doggui.invalid_dog.info.dog", (Object[])new Object[]{this.dog.getName().getString()});
        String owner_title = I18n.get((String)"doggui.invalid_dog.info.owner", (Object[])new Object[]{this.dog.getOwnersName().orElse((Component)Component.literal((String)"")).getString()});
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushMatrix();
        stack.scale(1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popMatrix();
        graphics.drawString(this.font, help, mX - this.font.width(help) / 2, pY += 40, -1);
        graphics.drawString(this.font, dog_title, mX - this.font.width(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, owner_title, mX - this.font.width(owner_title) / 2, pY += 9 + 3, -1);
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 80, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addUntameButton() {
        var untameButton = new CustomButton(this.width / 2 - 25, this.height / 2 + 58, 50, 20, (Component)Component.translatable((String)"doggui.untame.confirm.confirmed"), b -> {
            this.requestUntame();
            Minecraft.getInstance().setScreen(null);
        }){

            public void renderWidgetMain(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                String costStr = I18n.get((String)"doggui.talents.cost", (Object[])new Object[0]) + AmnesiaBoneItem.getUntameXPCost();
                int costStrColor = -1;
                int tX = this.getX() + this.width / 2 - DogUntameConfirmScreen.this.font.width(costStr) / 2;
                int n = this.getY() - 2;
                Objects.requireNonNull(DogUntameConfirmScreen.this.font);
                int tY = n - 9;
                graphics.drawString(DogUntameConfirmScreen.this.font, costStr, tX, tY, costStrColor);
                LocalPlayer player = Minecraft.getInstance().player;
                this.active = player != null && player.experienceLevel >= AmnesiaBoneItem.getUntameXPCost();
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                this.renderWidgetMain(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                if (this.active) {
                    return;
                }
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null || player.experienceLevel >= AmnesiaBoneItem.getUntameXPCost()) {
                    return;
                }
                MutableComponent c1 = Component.translatable((String)"doggui.detrain.talents.insufficent_xp");
                c1.setStyle(Style.EMPTY.withColor(-5111808).withBold(Boolean.valueOf(true)));
                ScreenUtil.renderComponentTooltip_21_5(graphics, DogUntameConfirmScreen.this.font, List.of(c1), mouseX, mouseY);
            }
        };
        LocalPlayer player = Minecraft.getInstance().player;
        untameButton.active = player != null && player.experienceLevel >= AmnesiaBoneItem.getUntameXPCost();
        this.addRenderableWidget((GuiEventListener)untameButton);
    }

    private void requestUntame() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogUntameData(this.dog.getId()));
    }
}

