/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView;

import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogSize;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.client.screen.PetSelectScreen;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;

public class DogStatusViewBoxElement
extends AbstractElement {
    private Dog dog;
    private Font font;
    private FlatButton petButton;

    public DogStatusViewBoxElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.font;
    }

    @Override
    public AbstractElement init() {
        this.petButton = new FlatButton(0, 0, 30, 50, (Component)Component.empty(), b -> PetSelectScreen.open()){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                if (this.isHovered) {
                    ToolTipOverlayManager.get().setComponents(List.of(Component.translatable((String)"doggui.home.pet_hint", (Object[])new Object[]{DogStatusViewBoxElement.this.dog.getGenderPronoun()})));
                }
            }
        };
        this.petButton.setX(this.getRealX() + this.getSizeX() / 2 - this.petButton.getWidth() / 2);
        this.petButton.setY(this.getRealY() + this.getSizeY() / 2 - this.petButton.getHeight() / 2 + 10);
        this.addChildren((GuiEventListener)this.petButton);
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawDogLevelKanji(graphics, mouseX, mouseY, partialTicks);
        int e_mX = this.getRealX() + this.getSizeX() / 2;
        int e_mY = this.getRealY() + this.getSizeY() / 2;
        this.renderVariantIcon(graphics, this.dog, this.getRealX() + this.getSizeX() - 16 - 3, this.getRealY() - 4);
        DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY + 32, 50, e_mX - mouseX, e_mY - mouseY);
        this.renderHealthBar(graphics, this.dog, e_mX - 41, this.getRealY() + this.getSizeY() - 10);
        int points = this.dog.getSpendablePoints();
        this.renderHungerStatusStr(graphics, this.dog, this.getRealX(), this.getRealY());
    }

    private void drawDogLevelKanji(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int imgeSize = 128;
        ScreenUtil.blit_21_3(graphics, DogStatusViewBoxElement.getKanjiDogLevel(this.dog), this.getRealX() + this.getSizeX() / 2 - imgeSize / 2, this.getRealY() + this.getSizeY() / 2 - imgeSize / 2, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
    }

    public static ResourceLocation getKanjiDogLevel(Dog dog) {
        DogLevel dogLevel = dog.getDogLevel();
        if (dogLevel.isFullKami()) {
            return Resources.KANJI_KAMI;
        }
        int level_normal = dogLevel.getLevel(DogLevel.Type.NORMAL);
        ResourceLocation ret = Resources.KANJI_NORMAL;
        if (level_normal >= 20) {
            ret = Resources.KANJI_SUPER;
        }
        if (level_normal >= 40) {
            ret = Resources.KANJI_MASTER;
        }
        if (level_normal >= 60) {
            ret = Resources.KANJI_KAMI;
        }
        return ret;
    }

    public static void renderDogInside(GuiGraphics graphics, Dog dog, int dog_mX, int dog_mY, int size, int lookX, int lookY) {
        boolean dogTooBig;
        DogSize currentDogSize = dog.getDogSize();
        boolean bl = dogTooBig = currentDogSize.getId() > DogSize.MODERATO.getId();
        if (dogTooBig) {
            dog.setDogSize(DogSize.MODERATO);
        }
        Component currentDogName = dog.getCustomName();
        String currentDogNameStr = "";
        boolean nameTooLong = false;
        if (currentDogName != null) {
            currentDogNameStr = currentDogName.getString();
            boolean bl2 = nameTooLong = currentDogNameStr.length() > 14;
        }
        if (nameTooLong) {
            String tempName = currentDogNameStr.substring(0, 13) + " ..";
            dog.setDogCustomName((Component)Component.literal((String)tempName));
        }
        ScreenUtil.renderEntityInInventoryFollowsMouse(graphics, dog_mX, dog_mY, size, lookX, lookY, dog);
        if (nameTooLong) {
            dog.setDogCustomName(currentDogName);
        }
        if (dogTooBig) {
            dog.setDogSize(currentDogSize);
        }
    }

    public void renderHealthBar(GuiGraphics graphics, Dog dog, int x, int y) {
        int pX = x;
        int pY = y;
        String healthStrPrefix = " x " + StatFormatter.DECIMAL_FORMAT.format(dog.getHealth());
        MutableComponent health_c0 = null;
        if (dog.hasWolfArmor()) {
            int wolf_armor_ext_hp = dog.wolfArmor().getMaxDamage() - dog.wolfArmor().getDamageValue();
            String healthStrPosfix = "+" + wolf_armor_ext_hp;
            health_c0 = Component.literal((String)healthStrPrefix).append((Component)Component.literal((String)healthStrPosfix).withStyle(Style.EMPTY.withColor(-3042707)));
        } else {
            String healthStrPosfix = "/" + (int)dog.getMaxHealth();
            String healthStr = healthStrPrefix + healthStrPosfix;
            health_c0 = Component.literal((String)healthStr);
        }
        ScreenUtil.blit_21_3(graphics, DogScreenOverlays.GUI_ICONS_LOCATION, pX += (80 - (8 + this.font.width((FormattedText)health_c0))) / 2, pY, 16, 0, 9, 9);
        ScreenUtil.blit_21_3(graphics, DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 0, 9, 9);
        graphics.drawString(this.font, (Component)health_c0, pX += 9, ++pY, -1);
    }

    private void renderHungerStatusStr(GuiGraphics graphics, Dog dog, int x, int y) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
            return;
        }
        ScreenUtil.blit_21_3(graphics, DogScreenOverlays.GUI_ICONS_LOCATION, x, y, 52, 27, 9, 9);
        int hunger = (int)dog.getDogHunger();
        graphics.drawString(this.font, "" + hunger, x + 10, y + 1, -1);
    }

    private void renderVariantIcon(GuiGraphics graphics, Dog dog, int x, int y) {
        DogVariant variant = dog.dogVariant();
        ResourceLocation iconLoc = variant.icon().orElse(null);
        if (iconLoc == null) {
            return;
        }
        int imgeSize = 16;
        ScreenUtil.blit_21_3(graphics, iconLoc, x, y, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
    }
}

