/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView;

import doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView.dropdown.AddGroupMenu.AddGroupMenu;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.GroupChangeHandlerSlice;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.DropdownMenuManager;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogGroupsData;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class GroupsListElement
extends AbstractElement {
    Dog dog;
    Font font;
    public static int LINE_SPACING = 5;
    public static int GROUP_SPACING = 9;

    public GroupsListElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        this.font = Minecraft.getInstance().font;
    }

    @Override
    public AbstractElement init() {
        this.getStateAndSubscribesTo(GroupChangeHandlerSlice.class, Object.class, null);
        int pX = this.getRealX();
        int pY = this.getRealY();
        List<DogGroupsManager.DogGroup> dogGroups = this.dog.getGroups().getGroupsReadOnly();
        for (DogGroupsManager.DogGroup group : dogGroups) {
            GroupEntryButton groupButton = new GroupEntryButton(pX, pY, group, this.font, this.dog);
            if (pX + groupButton.getWidth() > this.getRealX() + this.getSizeX()) {
                pX = this.getRealX();
                groupButton.setX(pX);
                groupButton.setY(pY += LINE_SPACING + groupButton.getHeight());
            }
            this.addChildren((GuiEventListener)groupButton);
            pX += GROUP_SPACING + groupButton.getWidth();
        }
        if (dogGroups.size() >= 3) {
            return this;
        }
        Objects.requireNonNull(this.font);
        int addButtonSize = 9 + 2;
        FlatButton addButton = new FlatButton(pX, pY, addButtonSize, addButtonSize, (Component)Component.literal((String)"+"), b -> this.displayGroupMenu(b.getX(), b.getY())){
            static final int DEFAULT_COLOR = 1214143837;
            static final int DEFAULT_HLCOLOR = -2090967715;

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                if (!this.active) {
                    return;
                }
                int cl = this.isHovered ? -2090967715 : 1214143837;
                graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, cl);
                int mX = this.getX() + this.width / 2;
                int mY = this.getY() + this.height / 2;
                Component msg = this.getMessage();
                int tX = mX - GroupsListElement.this.font.width((FormattedText)msg) / 2 + 1;
                Objects.requireNonNull(GroupsListElement.this.font);
                int tY = mY - 9 / 2 + 1;
                graphics.drawString(GroupsListElement.this.font, msg, tX, tY, -1);
            }
        };
        if ((pX += addButton.getWidth()) > this.getRealX() + this.getSizeX()) {
            pX = this.getRealX();
            addButton.setX(pX);
            addButton.setY(pY += LINE_SPACING + addButton.getHeight());
        }
        this.addChildren((GuiEventListener)addButton);
        pX += GROUP_SPACING;
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private void displayGroupMenu(int x, int y) {
        DropdownMenuManager.get(this.getScreen()).setActiveDropdownMenu(this.getScreen(), x + 5, y + 5, 120, 120, new AddGroupMenu(this, this.getScreen(), this.dog).setBackgroundColor(-13224394));
    }

    private static class GroupEntryButton
    extends FlatButton {
        public static final int PADDING_HORZ = 2;
        public static final int PADDING_VERT = 1;
        public static final int ICON_REM_X = 0;
        private Font font;
        private DogGroupsManager.DogGroup group;
        private Dog dog;
        private int textColor;

        public GroupEntryButton(int x, int y, DogGroupsManager.DogGroup group, Font font, Dog dog) {
            super(x, y, 0, 0, (Component)Component.literal((String)group.name), null);
            this.font = font;
            this.setWidth(4 + font.width((FormattedText)this.getMessage()));
            Objects.requireNonNull(font);
            this.setHeight(9 + 2);
            this.group = group;
            this.dog = dog;
            this.textColor = Util.getTextBlackOrWhite(group.color);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
            if (!this.active) {
                return;
            }
            int cl = this.group.color;
            graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, cl);
            int mX = this.getX() + this.width / 2;
            int mY = this.getY() + this.height / 2;
            Component msg = this.getMessage();
            int tX = mX - this.font.width((FormattedText)msg) / 2;
            Objects.requireNonNull(this.font);
            int tY = mY - 9 / 2;
            graphics.drawString(this.font, msg, tX, tY, this.textColor);
            if (this.isHovered) {
                this.drawRemoveIcon(graphics, mouseX, mouseY, pTicks);
            }
        }

        @Override
        public void onPress() {
            this.requestRemoveGroup();
        }

        private void requestRemoveGroup() {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogGroupsData.EDIT(this.dog.getId(), this.group, false));
        }

        private void drawRemoveIcon(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
            int iX = 0;
            ScreenUtil.blit_21_3(graphics, Resources.STYLE_ADD_REMOVE, this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() - 4, iX, 0, 9, 9);
        }
    }
}

