/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.common.entity.DogPettingManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class PetSelectScreen
extends StringEntrySelectScreen {
    private Font font;

    public PetSelectScreen() {
        super((Component)Component.empty());
        this.font = Minecraft.getInstance().font;
    }

    public static void open() {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new PetSelectScreen());
    }

    @Override
    public void init() {
        super.init();
        this.initEntries();
    }

    private void initEntries() {
        this.updateEntries(List.of(I18n.get((String)"dog.petmode.facerub", (Object[])new Object[0]), I18n.get((String)"dog.petmode.hug", (Object[])new Object[0]), I18n.get((String)"dog.petmode.belly_rub", (Object[])new Object[0]), I18n.get((String)"dog.petmode.back_hug", (Object[])new Object[0]), I18n.get((String)"doggytalents.screen.pet_select.exit", (Object[])new Object[0])));
    }

    @Override
    protected void onEntrySelected(int id) {
        switch (id) {
            case 0: {
                DTNClientPettingManager.get().setPetMode(DogPettingManager.DogPettingType.FACERUB);
                break;
            }
            case 1: {
                DTNClientPettingManager.get().setPetMode(DogPettingManager.DogPettingType.HUG);
                break;
            }
            case 2: {
                DTNClientPettingManager.get().setPetMode(DogPettingManager.DogPettingType.BELLY_RUB);
                break;
            }
            case 3: {
                DTNClientPettingManager.get().setPetMode(DogPettingManager.DogPettingType.BACK_HUG);
                break;
            }
            default: {
                DTNClientPettingManager.get().setPetMode(null);
            }
        }
        this.getMinecraft().setScreen(null);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawHelpStringsLeft(graphics, mouseX, mouseY, partialTicks);
        this.drawHelpStringsRight(graphics, mouseX, mouseY, partialTicks);
    }

    private void drawHelpStringsLeft(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.width / 2;
        int mY = this.height / 2;
        int t_width_limit = (this.width - this.getSelectAreaSize()) / 2 - 10;
        if ((t_width_limit = Mth.clamp((int)t_width_limit, (int)0, (int)150)) < 89) {
            return;
        }
        int line_spacing = 2;
        MutableComponent text = Component.translatable((String)"doggytalents.screen.pet_select.help.0");
        List text_lines = this.font.split((FormattedText)text, t_width_limit);
        int lines_count = text_lines.size();
        Objects.requireNonNull(this.font);
        int total_height = lines_count * 9 + (lines_count - 1) * 2;
        int tX = mX - this.getSelectAreaSize() / 2 - 5 - t_width_limit;
        int tY = mY - total_height / 2;
        for (FormattedCharSequence line : text_lines) {
            graphics.drawString(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }

    private void drawHelpStringsRight(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int mX = this.width / 2;
        int mY = this.height / 2;
        int t_width_limit = (this.width - this.getSelectAreaSize()) / 2 - 10;
        if ((t_width_limit = Mth.clamp((int)t_width_limit, (int)0, (int)150)) < 89) {
            return;
        }
        DogPettingManager.DogPettingType current_mode = DTNClientPettingManager.get().getPetMode();
        String current_mode_str = current_mode == DogPettingManager.DogPettingType.HUG ? I18n.get((String)"dog.petmode.hug", (Object[])new Object[0]) : I18n.get((String)"dog.petmode.facerub", (Object[])new Object[0]);
        MutableComponent title = Component.literal((String)current_mode_str).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        int line_spacing = 2;
        MutableComponent text = Component.translatable((String)"doggytalents.screen.pet_select.help.1");
        List text_lines = this.font.split((FormattedText)text, t_width_limit);
        int lines_count = text_lines.size() + 1;
        Objects.requireNonNull(this.font);
        int total_height = lines_count * 9 + (lines_count - 1) * 2;
        if (total_height >= this.height - 3) {
            return;
        }
        int tX = mX + this.getSelectAreaSize() / 2 + 8;
        int tY = mY - total_height / 2;
        graphics.drawString(this.font, (Component)title, tX, tY, -1);
        Objects.requireNonNull(this.font);
        tY += 9 + 2;
        for (FormattedCharSequence line : text_lines) {
            graphics.drawString(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }
}

