/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget.DoggySpin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.DogVariants;
import doggytalents.client.backward_imitate.GuiDoggySpinRenderer_1_21_7;
import doggytalents.client.entity.model.animation.DogAnimationSequences;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.dog.AmaterasuModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.oina.HopeModel;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.lib.Resources;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DoggySpinModel {
    private static DoggySpinModel INSTANCE = null;
    private Style style = Style.CHOPIN;
    private DogVariant variant = DogVariant.PALE;
    private int collarColor = -5231066;
    private static final List<Supplier<DogVariant>> possibleVariants = List.of(DogVariants.PALE, DogVariants.CHESTNUT, DogVariants.RUSTY, DogVariants.WOOD, DogVariants.STRIPED, DogVariants.SPOTTED, DogVariants.ASHEN, DogVariants.SNOWY, DogVariants.BLACK, DogVariants.MOLTEN, DogVariants.HIMALAYAN_SALT, DogVariants.CHERRY);
    private static final int[] possibleColors = new int[]{-5231066, -8337633, -12827478, -3715395, -15295332, -12930086, -816214, -7785800, -425955, -75715, -8170446, -14869215, -10585066};
    private static final Random random = new Random();
    private ModelPart root;
    private ModelPart tail;
    private ModelPart rootAmmy;
    private ModelPart tailAmmy;
    private ModelPart rootHope;
    private ModelPart tailHope;
    private Vector3f buf = new Vector3f();
    public static final AnimationDefinition TAIL_CHASE_LOOP = AnimationDefinition.Builder.withLength((float)1.75f).looping().addAnimation("head", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)2.25f, (float)-1.0f, (float)1.75f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)2.25f, (float)-1.0f, (float)1.75f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("head", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-90.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)-1.17f, (float)-2.22f, (float)-1.55f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)-1.17f, (float)-2.22f, (float)-1.55f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)-0.76f, (float)16.57f, (float)8.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)-0.76f, (float)16.57f, (float)8.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)1.4f, (float)-0.14f, (float)-0.79f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, (Vector3fc)KeyframeAnimations.posVec((float)0.25f, (float)-0.14f, (float)-1.27f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)1.4f, (float)-0.14f, (float)-0.79f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.7083434f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9583434f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.1676667f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.375f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.625f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)-2.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)-2.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.6766666f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9583434f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.125f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.375f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.625f, (Vector3fc)KeyframeAnimations.degreeVec((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.67f, (float)-1.28f, (float)-0.65f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)0.67f, (float)-1.28f, (float)-0.65f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("right_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, (Vector3fc)KeyframeAnimations.degreeVec((float)-30.04f, (float)-1.13f, (float)-8.27f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.degreeVec((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.7083434f, (Vector3fc)KeyframeAnimations.degreeVec((float)-30.04f, (float)-1.13f, (float)-8.27f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-1.25f, (float)2.75f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-1.25f, (float)2.75f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_front_leg", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)9.01f, (float)-20.7f, (float)-24.15f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)9.01f, (float)-20.7f, (float)-24.15f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)1.7f, (float)-2.68f, (float)-1.66f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)1.7f, (float)-2.68f, (float)-1.66f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("tail", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.7083434f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9583434f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.1676667f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.375f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.625f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.8343333f, (Vector3fc)KeyframeAnimations.degreeVec((float)120.0f, (float)13.33f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("upper_body", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)-0.06f, (float)-2.33f, (float)-0.32f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)-0.06f, (float)-2.33f, (float)-0.32f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("upper_body", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)-4.75f, (float)-36.46f, (float)-8.92f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)-4.75f, (float)-36.46f, (float)-8.92f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("root", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.9583434f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("root", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(0.5f, (Vector3fc)KeyframeAnimations.degreeVec((float)-30.0f, (float)-360.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)15.0f, (float)-720.0f, (float)25.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.4167666f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-1080.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR), new Keyframe(1.75f, (Vector3fc)KeyframeAnimations.degreeVec((float)0.0f, (float)-1440.0f, (float)0.0f), AnimationChannel.Interpolations.LINEAR)})).addAnimation("right_ear", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("right_ear", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)-45.19f, (float)-0.15f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_ear", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.posVec((float)0.0f, (float)-0.25f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("left_ear", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, (Vector3fc)KeyframeAnimations.degreeVec((float)-32.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();

    public static DoggySpinModel get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("DoggySpinModel is not initilized. If this exception get thrown again, please disable DTN world load icon and report to the DTN Server.");
        }
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new DoggySpinModel();
    }

    private DoggySpinModel() {
        this.root = DogModel.createBodyLayer().bakeRoot();
        this.rootAmmy = AmaterasuModel.createBodyLayer().bakeRoot();
        this.rootHope = HopeModel.createBodyLayer().bakeRoot();
        this.tail = this.root.getChild("tail");
        this.tailAmmy = this.rootAmmy.getChild("tail");
        this.tailHope = this.rootHope.getChild("tail");
    }

    private ModelPart getRootForStyle() {
        if (this.style == Style.AMMY) {
            return this.rootAmmy;
        }
        if (this.style == Style.HOPE) {
            return this.rootHope;
        }
        return this.root;
    }

    private ModelPart getTailForStyle() {
        if (this.style == Style.AMMY) {
            return this.tailAmmy;
        }
        if (this.style == Style.HOPE) {
            return this.tailHope;
        }
        return this.tail;
    }

    private void pickDogVariant() {
        if (possibleVariants.isEmpty()) {
            return;
        }
        int random_indx = random.nextInt(possibleVariants.size());
        this.variant = possibleVariants.get(random_indx).get();
    }

    private void pickCollarColor() {
        if (possibleColors.length <= 0) {
            return;
        }
        int random_indx = random.nextInt(possibleColors.length);
        this.collarColor = possibleColors[random_indx];
    }

    public void configureRandomStyle() {
        float r = random.nextFloat();
        Style selected_style = Style.CHOPIN;
        selected_style = r >= 0.5f ? Style.CHOPIN : (r >= 0.27f ? Style.BACKFLIP : (r >= 0.04f ? Style.SIT : (((Boolean)ConfigHandler.CLIENT.AMMY_SPINNA.get()).booleanValue() ? (r >= 0.01f ? Style.AMMY : Style.HOPE) : Style.BACKFLIP)));
        this.style = selected_style;
        if (this.style != Style.AMMY && this.style != Style.HOPE) {
            this.pickCollarColor();
            this.pickDogVariant();
        }
    }

    private void resetPart(ModelPart part) {
        if (part == this.getTailForStyle()) {
            part.resetPose();
            this.getTailForStyle().xRot = 1.73f;
            return;
        }
        part.resetPose();
    }

    public void resetAllPose() {
        if (this.style == Style.AMMY) {
            this.rootAmmy.getAllParts().forEach(x -> x.resetPose());
            return;
        }
        if (this.style == Style.HOPE) {
            this.rootHope.getAllParts().forEach(x -> x.resetPose());
            return;
        }
        this.root.getAllParts().forEach(x -> x.resetPose());
    }

    public void prepareRender(long elapsed_millis) {
        this.resetAllPose();
        if (this.style == Style.CHOPIN || this.style == Style.AMMY || this.style == Style.HOPE) {
            long len_millis = Mth.ceil((float)(TAIL_CHASE_LOOP.lengthInSeconds() * 1000.0f));
            long passed_millis = elapsed_millis % len_millis;
            AnimationDefinition seq = TAIL_CHASE_LOOP;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        } else if (this.style == Style.SIT) {
            long len_millis = Mth.ceil((float)(DogAnimationSequences.SIT_LOOK_AROUND.lengthInSeconds() * 1000.0f));
            long passed_millis = (long)Mth.floor((float)((float)elapsed_millis * 1.7f)) % len_millis;
            AnimationDefinition seq = DogAnimationSequences.SIT_LOOK_AROUND;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        } else if (this.style == Style.BACKFLIP) {
            long len_millis = Mth.ceil((float)(DogAnimationSequences.BACKFLIP.lengthInSeconds() * 1000.0f));
            long passed_millis = elapsed_millis % len_millis;
            AnimationDefinition seq = DogAnimationSequences.BACKFLIP;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        }
    }

    public void renderGui(GuiGraphics graphics, float mid_x, float mid_y) {
        Quaternionf rotation;
        int scale = 70;
        Vector3f offset = new Vector3f(0.0f, 0.4375f, 0.0f);
        if (this.style == Style.CHOPIN || this.style == Style.AMMY || this.style == Style.HOPE) {
            rotation = Axis.XP.rotationDegrees(15.0f);
        } else if (this.style == Style.BACKFLIP) {
            rotation = Axis.XP.rotationDegrees(4.0f).mul((Quaternionfc)Axis.YP.rotationDegrees(20.0f));
            offset.sub(0.0f, -0.15f, 0.0f);
        } else {
            rotation = Axis.XP.rotationDegrees(10.0f);
            offset.sub(0.0f, -0.08f, 0.0f);
        }
        this.renderGui(graphics, mid_x, mid_y, scale, offset, rotation);
    }

    public void renderGui(GuiGraphics graphics, float mid_x, float mid_y, float scale, Vector3f offset, Quaternionf rot) {
        GuiDoggySpinRenderer_1_21_7.doRenderDoggySpinModel(graphics, mid_x, mid_y, scale, offset, rot, this::doRenderModel);
    }

    private void doRenderModel(PoseStack stack, MultiBufferSource source) {
        if (this.style == Style.AMMY) {
            this.doRenderModelWithTexture(stack, source, true, Resources.OKAMI_AMATERASU, -1);
            return;
        }
        if (this.style == Style.HOPE) {
            this.doRenderModelWithTexture(stack, source, true, Resources.SOL_HOPE, -1);
            return;
        }
        this.doRenderModelWithTexture(stack, source, false, this.variant.texture(), -1);
        this.doRenderModelWithTexture(stack, source, false, Resources.COLLAR_THICC, this.collarColor);
    }

    private void doRenderModelWithTexture(PoseStack stack, MultiBufferSource source, boolean translucent, ResourceLocation loc, int color) {
        RenderType renderType = translucent ? RenderType.entityTranslucent((ResourceLocation)loc) : RenderType.entityCutoutNoCull((ResourceLocation)loc);
        VertexConsumer buffer = source.getBuffer(renderType);
        this.renderToBuffer(stack, buffer, 0xF000F0, OverlayTexture.pack((int)OverlayTexture.u((float)0.0f), (int)OverlayTexture.v((boolean)false)), color);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay_coord, int color_overlay) {
        ModelPart root = this.getRootForStyle();
        Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
        stack.pushPose();
        stack.translate((double)(root.x / 16.0f), (double)(root.y / 16.0f), (double)(root.z / 16.0f));
        stack.translate((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (root.zRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.ZP.rotation(root.zRot));
        }
        if (root.yRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.YP.rotation(root.yRot));
        }
        if (root.xRot != 0.0f) {
            stack.mulPose((Quaternionfc)Axis.XP.rotation(root.xRot));
        }
        float xRot0 = root.xRot;
        float yRot0 = root.yRot;
        float zRot0 = root.zRot;
        float x0 = root.x;
        float y0 = root.y;
        float z0 = root.z;
        root.xRot = 0.0f;
        root.yRot = 0.0f;
        root.zRot = 0.0f;
        root.x = 0.0f;
        root.y = 0.0f;
        root.z = 0.0f;
        stack.pushPose();
        stack.translate((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        root.render(stack, consumer, light, overlay_coord, color_overlay);
        stack.popPose();
        stack.popPose();
        root.xRot = xRot0;
        root.yRot = yRot0;
        root.zRot = zRot0;
        root.x = x0;
        root.y = y0;
        root.z = z0;
    }

    public static enum Style {
        CHOPIN,
        BACKFLIP,
        SIT,
        AMMY,
        HOPE;

    }
}

