/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.backward_imitate;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import doggytalents.DoggyTalentsNext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public abstract class SimpleJsonResourceReloadListener_1_21_9
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private final Gson gson;
    private final String directory;

    public SimpleJsonResourceReloadListener_1_21_9(Gson gson, String dir) {
        this.gson = gson;
        this.directory = dir;
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, JsonElement> jsons = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener_1_21_9.scanDirectory(resourceManager, this.directory, this.gson, jsons);
        return jsons;
    }

    public static void scanDirectory(ResourceManager resourceManager, String directory, Gson gson, Map<ResourceLocation, JsonElement> outputJsons) {
        FileToIdConverter file_to_id = FileToIdConverter.json((String)directory);
        for (Map.Entry entry : file_to_id.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation entry_path = (ResourceLocation)entry.getKey();
            ResourceLocation entry_id = file_to_id.fileToId(entry_path);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement entry_json = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonElement.class);
                    JsonElement entry_json0 = outputJsons.put(entry_id, entry_json);
                    if (entry_json0 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(entry_id));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                DoggyTalentsNext.LOGGER.error("Couldn't parse data file {} from {}", (Object)entry_id, (Object)entry_path, (Object)jsonparseexception);
            }
        }
    }
}

