/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public class CasingMaterial
extends ICasingMaterial {
    private final Supplier<Block> block;
    protected ResourceLocation texture;
    protected final ResourceLocation id;
    @Nullable
    private String translationKey;

    public CasingMaterial(ResourceLocation id, Supplier<Block> blockIn) {
        this.block = blockIn;
        this.id = id;
    }

    public CasingMaterial(ResourceLocation id, Supplier<Block> blockIn, ResourceLocation texture) {
        this.block = blockIn;
        this.texture = texture;
        this.id = id;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)this.block.get());
            this.texture = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath()));
        }
        return this.texture;
    }

    @Override
    public Component getTooltip() {
        Block block = this.block.get();
        if (block == null) {
            return Component.empty();
        }
        return Component.translatable((String)block.asItem().getDescriptionId()).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(block.defaultMapColor().col));
    }

    @Override
    public Optional<Ingredient> getIngredient() {
        return Optional.ofNullable(this.block.get()).flatMap(block -> ItemUtil.getBlockIngredient(block));
    }

    @Override
    public ResourceLocation getSaveKey() {
        return this.id;
    }
}

