/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogBathBlockEntity
extends BlockEntity {
    public int tickTillProvoke = 10;

    public DogBathBlockEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.DOG_BATH.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        if (!(blockEntity instanceof DogBathBlockEntity)) {
            return;
        }
        DogBathBlockEntity bath = (DogBathBlockEntity)blockEntity;
        if (--bath.tickTillProvoke > 0) {
            return;
        }
        bath.tickTillProvoke = 10;
        List dogList = level.getEntitiesOfClass(Dog.class, new AABB(pos).inflate(5.0, 3.0, 5.0));
        if (dogList.isEmpty()) {
            return;
        }
        for (Dog dog : dogList) {
            if (dog.isBusy() || !dog.isDoingFine() || dog.isOrderedToSit() || dog.isInSittingPose() || dog.getAnim() != DogAnimation.NONE || (double)dog.getRandom().nextFloat() >= 0.02) continue;
            dog.triggerAction(new DogDrinkFromFoodBowl(dog, bath));
            bath.tickTillProvoke += 40 + dog.getRandom().nextInt(61);
            break;
        }
    }

    public static class DogDrinkFromFoodBowl
    extends TriggerableAction {
        private final DogBathBlockEntity bath;
        private int tickTillPathRecalc;
        private int goToBowlTimeout = 0;
        private boolean isDoingAnim;
        private int stopTick;
        private int animTick;

        public DogDrinkFromFoodBowl(Dog dog, DogBathBlockEntity bath) {
            super(dog, false, false);
            this.bath = bath;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
            this.isDoingAnim = false;
            this.animTick = 0;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public void tick() {
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isDoingAnim) {
                if (!this.stillInDrinkDistance()) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.getAnim() != DogAnimation.DRINK_WATER) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.tickCount >= this.stopTick) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean dist_can_start_drinking = this.distCanStartDrinking();
                if (!dist_can_start_drinking) {
                    --this.goToBowlTimeout;
                }
                if (this.goToBowlTimeout <= 0 && !dist_can_start_drinking) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            Vec3 bowlPos = this.getBowPos();
            this.dog.getLookControl().setLookAt(bowlPos.x, bowlPos.y, bowlPos.z, 10.0f, (float)this.dog.getMaxHeadXRot());
            if (this.isDoingAnim) {
                this.doAnim();
            } else {
                this.moveToBowl(this.distCanStartDrinking());
            }
        }

        private void moveToBowl(boolean is_close_to_bowl) {
            if (is_close_to_bowl) {
                this.isDoingAnim = true;
                this.dog.setAnim(DogAnimation.DRINK_WATER);
                this.stopTick = this.dog.tickCount + DogAnimation.DRINK_WATER.getLengthTicks();
                this.dog.getNavigation().stop();
                return;
            }
            Vec3 bowlPos = this.getBowPos();
            if (--this.tickTillPathRecalc <= 0) {
                this.tickTillPathRecalc = 10;
                if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                    this.dog.getNavigation().moveTo(bowlPos.x, bowlPos.y, bowlPos.z, (double)this.dog.getUrgentSpeedModifier());
                }
            }
        }

        private void doAnim() {
            Level level;
            ++this.animTick;
            if (5 <= this.animTick && this.animTick <= 35 && this.animTick % 4 == 0) {
                this.dog.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.value(), 0.2f, this.dog.level().random.nextFloat() * 0.1f + 0.9f);
            }
            if (this.animTick == 50 && (level = this.dog.level()) instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                sLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, this.dog.getX(), this.dog.getY(), this.dog.getZ(), 10, (double)this.dog.getBbWidth(), (double)0.8f, (double)this.dog.getBbWidth(), 0.1);
            }
            float backward_strafe_dist = 0.6f;
            if (this.getBowlDistanceSqr() < (double)(backward_strafe_dist * backward_strafe_dist)) {
                this.dog.getMoveControl().strafe(-0.5f, 0.0f);
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.DRINK_WATER) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }

        private boolean stillValidTarget() {
            if (this.bath.isRemoved()) {
                return false;
            }
            return !(this.getBowlDistanceSqr() > 256.0);
        }

        private boolean distCanStartDrinking() {
            double max_dist = (double)(this.dog.getBbWidth() / 2.0f) + 0.5;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private boolean stillInDrinkDistance() {
            double max_dist = (double)(this.dog.getBbWidth() / 2.0f) + 0.5 + 0.3;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private double getBowlDistanceSqr() {
            Vec3 bowlPos = this.getBowPos();
            return this.dog.distanceToSqr(bowlPos);
        }

        private Vec3 getBowPos() {
            return Vec3.atBottomCenterOf((Vec3i)this.bath.getBlockPos());
        }
    }
}

