/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DTLootModifierProvider
extends GlobalLootModifierProvider {
    public static final float RICE_FROM_GRASS_DROP_CHANCE = 0.125f;
    public static final float SOY_FROM_ZOMBIE_DROP_CHANCE = 0.01f;
    public static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> CODEC = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"doggytalents");
    public static final Supplier<MapCodec<? extends IGlobalLootModifier>> RICE_FROM_GRASS_CODEC = CODEC.register("rice_from_grass", RiceFromGrass::getCodec);
    public static final Supplier<MapCodec<? extends IGlobalLootModifier>> SOY_FROM_ZOMBIE_CODEC = CODEC.register("soy_from_zombie", SoyFromZombies::getCodec);

    public DTLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> prov) {
        super(output, prov, "doggytalents");
    }

    protected void start() {
        this.add("rice_from_grass_modifier", (IGlobalLootModifier)this.createGrassRiceModifer(), new ICondition[0]);
        this.add("soy_from_zombie_modifier", (IGlobalLootModifier)this.createSoyFromZombiesModifier(), new ICondition[0]);
    }

    private RiceFromGrass createGrassRiceModifer() {
        LootItemCondition correct_id_codition = LootTableIdCondition.builder((ResourceLocation)((ResourceKey)Blocks.SHORT_GRASS.getLootTable().get()).location()).build();
        LootItemCondition not_shear_condtion = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), new ItemLike[]{Items.SHEARS})).invert().build();
        LootItemCondition random_condition = LootItemRandomChanceCondition.randomChance((float)0.125f).build();
        LootItemCondition[] conditions = new LootItemCondition[]{correct_id_codition, not_shear_condtion, random_condition};
        return new RiceFromGrass(conditions);
    }

    private SoyFromZombies createSoyFromZombiesModifier() {
        LootItemCondition killed_by_dog_condition = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)this.registries.lookupOrThrow(Registries.ENTITY_TYPE), DoggyEntityTypes.DOG.get())).build();
        LootItemCondition drop_soy_condition = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)this.registries.lookupOrThrow(Registries.ENTITY_TYPE), DoggyTags.DROP_SOY_WHEN_DOG_KILL)).build();
        LootItemCondition random_condition = LootItemRandomChanceCondition.randomChance((float)0.01f).build();
        LootItemCondition[] conditions = new LootItemCondition[]{killed_by_dog_condition, drop_soy_condition, random_condition};
        return new SoyFromZombies(conditions);
    }

    public static class RiceFromGrass
    extends LootModifier {
        private static MapCodec<LootModifier> CODEC = RecordCodecBuilder.mapCodec(x -> RiceFromGrass.codecStart((RecordCodecBuilder.Instance)x).apply((Applicative)x, RiceFromGrass::new));

        public static MapCodec<LootModifier> getCodec() {
            return CODEC;
        }

        protected RiceFromGrass(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return RICE_FROM_GRASS_CODEC.get();
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.add((Object)new ItemStack((ItemLike)DoggyItems.RICE_GRAINS.get()));
            return generatedLoot;
        }
    }

    public static class SoyFromZombies
    extends LootModifier {
        private static MapCodec<LootModifier> CODEC = RecordCodecBuilder.mapCodec(x -> SoyFromZombies.codecStart((RecordCodecBuilder.Instance)x).apply((Applicative)x, SoyFromZombies::new));

        public static MapCodec<LootModifier> getCodec() {
            return CODEC;
        }

        protected SoyFromZombies(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return SOY_FROM_ZOMBIE_CODEC.get();
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            int r = 1 + context.getRandom().nextInt(3);
            generatedLoot.add((Object)new ItemStack((ItemLike)DoggyItems.SOY_BEANS.get(), r));
            return generatedLoot;
        }
    }
}

