/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.common.backward_imitate.DataUtil_1_21_9;
import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class DTLootTableProvider
extends LootTableProvider {
    public DTLootTableProvider(PackOutput p_254123_, CompletableFuture<HolderLookup.Provider> prov) {
        super(p_254123_, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.ENTITY)), prov);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreportercollector) {
    }

    private static class Entities
    extends EntityLootSubProvider {
        protected Entities(HolderLookup.Provider prov) {
            super(FeatureFlags.VANILLA_SET, prov);
        }

        protected void registerNoLoot(Supplier<? extends EntityType<?>> type) {
            this.add(type.get(), LootTable.lootTable());
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return new ArrayList<EntityType<Dog>>(List.of(DoggyEntityTypes.DOG.get())).stream();
        }

        public void generate() {
            this.registerNoLoot(DoggyEntityTypes.DOG);
        }
    }

    private static class Blocks
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(DoggyBlocks.DOG_BED.get()).map(ItemLike::asItem).collect(Collectors.toSet());

        protected Blocks(HolderLookup.Provider prov) {
            super(EXPLOSION_RESISTANT, FeatureFlags.VANILLA_SET, prov);
        }

        private void dropDogBed(Supplier<? extends Block> block) {
            LootTable.Builder lootTableBuilder = LootTable.lootTable().withPool(((LootPool.Builder)this.applyExplosionCondition((ItemLike)block.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)block.get())).apply((LootItemFunction.Builder)CopyCustomDataFunction.copyData((NbtProvider)DataUtil_1_21_9.getBlockEntityNbtProvider()).copy("casingId", "doggytalents.casingId").copy("beddingId", "doggytalents.beddingId").copy("ownerId", "doggytalents.ownerId").copy("name", "doggytalents.name").copy("ownerName", "doggytalents.ownerName"))));
            this.add(block.get(), lootTableBuilder);
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.dropSelf(block.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return DoggyBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }

        protected void generate() {
            this.dropsSelf(DoggyBlocks.DOG_BATH);
            this.dropDogBed(DoggyBlocks.DOG_BED);
            this.dropsSelf(DoggyBlocks.FOOD_BOWL);
            this.dropsSelf(DoggyBlocks.RICE_MILL);
            LootItemBlockStatePropertyCondition.Builder RICE_LOOT_CONDITION = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)DoggyBlocks.RICE_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoggyBlocks.RICE_CROP.get().getAgeProperty(), 7));
            AllOfCondition.Builder KOJI_LOOT_CONDITION = LootItemRandomChanceCondition.randomChance((float)0.05f).and((LootItemCondition.Builder)RICE_LOOT_CONDITION);
            LootPool.Builder KOJI_LOOT_POOL = LootPool.lootPool().when((LootItemCondition.Builder)KOJI_LOOT_CONDITION).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)DoggyItems.KOJI.get()))).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3));
            LootTable.Builder RICE_LOOTABLE = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)DoggyItems.RICE_WHEAT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).when((LootItemCondition.Builder)RICE_LOOT_CONDITION)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)DoggyItems.RICE_GRAINS.get()))))).withPool(KOJI_LOOT_POOL).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
            this.add((Block)DoggyBlocks.RICE_CROP.get(), RICE_LOOTABLE);
            LootItemBlockStatePropertyCondition.Builder SOY_LOOT_CONDITION = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)DoggyBlocks.SOY_CROP.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoggyBlocks.SOY_CROP.get().getAgeProperty(), 7));
            this.add((Block)DoggyBlocks.SOY_CROP.get(), this.createCropDrops((Block)DoggyBlocks.SOY_CROP.get(), DoggyItems.SOY_PODS.get(), DoggyItems.SOY_BEANS.get(), (LootItemCondition.Builder)SOY_LOOT_CONDITION));
        }
    }
}

