/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.storage.DogRespawnStorage;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DogDuplicationDetection {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/dupeDetect");
    public static final String DUPE_DETECT_TAG_ID = "DTN_DupeDetect";
    private final Dog dog;
    private DetectDuplicateContext detectDuplicateContext = DetectDuplicateContext.EMPTY;
    private UUID sessionUUID = null;
    public static Codec<DetectDuplicateContext> CTX_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)UUIDUtil.CODEC.fieldOf("uuid_self").forGetter(DetectDuplicateContext::selfUUID), (App)UUIDUtil.CODEC.fieldOf("uuid_owner").forGetter(DetectDuplicateContext::ownerUUID), (App)UUIDUtil.CODEC.optionalFieldOf("uuid_session").forGetter(DetectDuplicateContext::sessionUUID)).apply((Applicative)builder, DetectDuplicateContext::of));

    public DogDuplicationDetection(Dog dog) {
        this.dog = dog;
    }

    public static boolean isEffective(Level level) {
        if (level.isClientSide) {
            return false;
        }
        return (Boolean)ConfigHandler.SERVER.TRUST_THIRD_PARTY_STORAGE.get() == false;
    }

    public static void beforeEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!DogDuplicationDetection.isEffective(event.getLevel())) {
            return;
        }
        if (event.loadedFromDisk()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getType() != DoggyEntityTypes.DOG.get()) {
            return;
        }
        if (!(entity instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)entity;
        DogDuplicationDetection detector = dog.getDogDuplicationDetection();
        if (!detector.isDuplicate()) {
            return;
        }
        event.setCanceled(true);
    }

    public static void afterDogJoinLevel(Dog dog, DogLocationData data) {
        if (!DogDuplicationDetection.isEffective(dog.level())) {
            return;
        }
        DogDuplicationDetection detector = dog.getDogDuplicationDetection();
        detector.detectDuplicateContext = DetectDuplicateContext.EMPTY;
        detector.accquireSessionUUID(data);
    }

    public static void onSessionUUIDUpdate(Dog dog, UUID sessionUUID) {
        if (!DogDuplicationDetection.isEffective(dog.level())) {
            return;
        }
        dog.getDogDuplicationDetection().sessionUUID = sessionUUID;
    }

    public static void onAboutToRespawn(Dog dog) {
        if (!DogDuplicationDetection.isEffective(dog.level())) {
            return;
        }
        DogDuplicationDetection detector = dog.getDogDuplicationDetection();
        detector.detectDuplicateContext = DetectDuplicateContext.EMPTY;
    }

    public void load(CompoundTag_1_21_5 compound, Consumer<UUID> owner_setter) {
        if (!DogDuplicationDetection.isEffective(this.dog.level())) {
            return;
        }
        if (!compound.contains(DUPE_DETECT_TAG_ID, 10)) {
            return;
        }
        CompoundTag_1_21_5 tag = compound.getCompound(DUPE_DETECT_TAG_ID);
        this.detectDuplicateContext = DetectDuplicateContext.load((Tag)tag.wrapped());
        this.checkAndRecorrectOwner(owner_setter);
    }

    private void checkAndRecorrectOwner(Consumer<UUID> owner_setter) {
        if (this.detectDuplicateContext.isEmpty()) {
            return;
        }
        DetectDuplicateContext ctx = this.detectDuplicateContext;
        UUID ownerUUID = ctx.ownerUUID();
        if (ObjectUtils.notEqual((Object)ownerUUID, (Object)this.dog.getOwnerUUID())) {
            owner_setter.accept(ownerUUID);
        }
    }

    public void save(CompoundTag compound) {
        if (!DogDuplicationDetection.isEffective(this.dog.level())) {
            return;
        }
        if (!this.detectDuplicateContext.isEmpty()) {
            return;
        }
        DetectDuplicateContext ctx = DetectDuplicateContext.of(this.dog.getUUID(), this.dog.getOwnerUUID(), this.sessionUUID);
        if (ctx.isEmpty()) {
            return;
        }
        Optional result = Optional.empty();
        try {
            result = ctx.save().result();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.ifPresent(result_tag -> compound.put(DUPE_DETECT_TAG_ID, result_tag));
    }

    private boolean isDuplicate() {
        if (this.detectDuplicateContext.isEmpty()) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.TRUST_THIRD_PARTY_STORAGE.get()).booleanValue()) {
            return false;
        }
        DetectDuplicateContext ctx = this.detectDuplicateContext;
        UUID uuid_self = ctx.selfUUID();
        UUID uuid_owner = ctx.ownerUUID();
        UUID uuid_session = ctx.sessionUUID().orElse(null);
        boolean isDuplicate = false;
        if (!isDuplicate && this.checkRespawnStorageForDuplicate(uuid_self, uuid_owner)) {
            isDuplicate = true;
        }
        if (!isDuplicate && this.checkLocationStorageForDuplicate(uuid_self, uuid_owner, uuid_session)) {
            isDuplicate = true;
        }
        if (!isDuplicate) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.THIRD_PARTY_STORE_WARN.get()).booleanValue()) {
            LOGGER.error("Dog [ uuid = " + String.valueOf(uuid_self) + " owner_uuid = " + String.valueOf(uuid_owner) + " ] has been restored from third-party storage which may leads to duplications. Please restore this Dog via its Dog Bed, by using a Totem of Undying on an Unlinked Dog Bed or via [ /dog revive ] instead. To allow the Dog to be restored from third-party storage, set trust_third_party_storage=true. To disable this message, set third_party_store_warn=false");
        }
        return true;
    }

    private boolean checkRespawnStorageForDuplicate(UUID uuid, UUID ownerUUID) {
        DogRespawnStorage storage = DogRespawnStorage.get(this.dog.level());
        if (storage == null) {
            return false;
        }
        DogRespawnData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        return !ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID);
    }

    private boolean checkLocationStorageForDuplicate(UUID uuid, UUID ownerUUID, UUID sessionUUID) {
        DogLocationStorage storage = DogLocationStorage.get(this.dog.level());
        if (storage == null) {
            return false;
        }
        DogLocationData data = storage.getData(uuid);
        if (data == null) {
            return false;
        }
        UUID ownerUUID0 = data.getOwnerId();
        if (ownerUUID0 == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID0, (Object)ownerUUID)) {
            return false;
        }
        UUID correctSessionUUID = data.getSessionUUID();
        if (correctSessionUUID == null) {
            return false;
        }
        return ObjectUtils.notEqual((Object)correctSessionUUID, (Object)sessionUUID);
    }

    private void accquireSessionUUID(DogLocationData data) {
        UUID sessionUUID;
        if (data == null) {
            return;
        }
        this.sessionUUID = sessionUUID = data.getSessionUUID();
    }

    public static class DetectDuplicateContext {
        public static final DetectDuplicateContext EMPTY = new DetectDuplicateContext(null, null, Optional.empty());
        private final UUID selfUUID;
        private final UUID ownerUUID;
        private final Optional<UUID> sessionUUID;

        public static DetectDuplicateContext of(UUID selfUUID, UUID ownerUUID, Optional<UUID> sessionUUID) {
            if (selfUUID == null || ownerUUID == null) {
                return EMPTY;
            }
            return new DetectDuplicateContext(selfUUID, ownerUUID, sessionUUID);
        }

        public static DetectDuplicateContext of(UUID selfUUID, UUID ownerUUID, UUID sessionUUID) {
            return DetectDuplicateContext.of(selfUUID, ownerUUID, Optional.ofNullable(sessionUUID));
        }

        private DetectDuplicateContext(UUID selfUUID, UUID ownerUUID, Optional<UUID> sessionUUID) {
            this.selfUUID = selfUUID;
            this.ownerUUID = ownerUUID;
            this.sessionUUID = sessionUUID;
        }

        public UUID selfUUID() {
            return this.selfUUID;
        }

        public UUID ownerUUID() {
            return this.ownerUUID;
        }

        public Optional<UUID> sessionUUID() {
            return this.sessionUUID;
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        public DataResult<Tag> save() {
            if (this.isEmpty()) {
                return DataResult.error(() -> "Empty!");
            }
            return CTX_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this);
        }

        public static DetectDuplicateContext load(Tag tag) {
            DetectDuplicateContext ret = EMPTY;
            try {
                ret = CTX_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().map(pair -> (DetectDuplicateContext)pair.getFirst()).orElse(EMPTY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
    }
}

