/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import com.google.common.collect.Maps;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class FieryReflector
extends Accessory
implements IAccessoryHasModel {
    private final Type type;

    public FieryReflector(Supplier<? extends ItemLike> itemIn, Type type) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = type;
    }

    public FieryReflector(Supplier<? extends ItemLike> itemIn) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = Type.DIVINE_RETRIBUTION;
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.FIERY_REFL;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this, this.type);
    }

    public static enum Type {
        DIVINE_RETRIBUTION,
        SOUL_REFLECTOR;

    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public static final int MAX_COOKED = 10;
        public static final int COOK_RADIUS = 1;
        private final Map<ItemEntity, Integer> cooking = Maps.newHashMap();
        private int tickTillRefresh = 0;
        private final Type type;
        private final ArrayList<Pair<Item, RecipeHolder<SmeltingRecipe>>> recipeCache = new ArrayList(5);
        public boolean debugForceLowFlameRender = false;

        public Inst(Accessory typeIn, Type type) {
            super(typeIn);
            this.type = type;
        }

        @Override
        public void tick(AbstractDog dogIn) {
            this.invalidateCache();
            this.invalidateCooking(dogIn);
            this.tickReflectorEffect(dogIn);
            this.tickDoingCooking(dogIn);
        }

        @Override
        public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
            Dog dog;
            if (dogIn.level().isClientSide && playerIn.getItemInHand(handIn).getItem() == Items.STRING && dogIn instanceof Dog && (dog = (Dog)dogIn).isDogInAnimDebug()) {
                this.debugForceLowFlameRender = !this.debugForceLowFlameRender;
            }
            return DogInteractionResult.PASS;
        }

        private void tickReflectorEffect(AbstractDog dogIn) {
            if (dogIn.isDefeated()) {
                return;
            }
            if (dogIn.level().isClientSide) {
                if (dogIn instanceof Dog) {
                    Dog dog = (Dog)dogIn;
                    this.addFlameParticles(dog);
                }
                this.playSizzleSound(dogIn);
            }
        }

        private void tickDoingCooking(AbstractDog dog) {
            if (dog.isDefeated()) {
                return;
            }
            if (--this.tickTillRefresh <= 0) {
                this.tickTillRefresh = 10;
                this.populateCooking(dog);
            }
            this.cookAllCooking(dog);
        }

        private void addFlameParticles(Dog dog) {
            boolean higher_flame;
            float offsetY = 0.24f;
            DogPose pose = dog.getDogPose();
            boolean bl = higher_flame = !(pose != DogPose.STAND && pose != DogPose.FLYING || this.debugForceLowFlameRender && dog.isDogInAnimDebug());
            if (higher_flame) {
                offsetY += dog.getDogVisualBbHeight();
            }
            float a1 = dog.getClientAnimatedYBodyRotInRadians();
            float dx1 = -Mth.sin((float)a1);
            float dz1 = Mth.cos((float)a1);
            float f1 = (dog.getRandom().nextFloat() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            float f2 = (dog.getRandom().nextFloat() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            SimpleParticleType flame_particle = this.type == Type.SOUL_REFLECTOR ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
            dog.level().addParticle((ParticleOptions)flame_particle, dog.getX() + (double)f1 - (double)dx1 * ((double)dog.getDogVisualBbWidth() * 1.8), dog.getY() + (double)offsetY, dog.getZ() + (double)f2 - (double)dz1 * ((double)dog.getDogVisualBbWidth() * 1.8), (double)(-dx1) * 0.05, -0.01, (double)(-dz1) * 0.05);
        }

        private void playSizzleSound(AbstractDog dog) {
            RandomSource r = dog.getRandom();
            if (r.nextInt(24) == 0) {
                dog.level().playLocalSound(dog.getX(), dog.getY() + (double)dog.getBbHeight() + 0.24, dog.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.AMBIENT, 0.6f * r.nextFloat(), r.nextFloat() * 0.7f + 0.3f, false);
            }
        }

        private void populateCooking(AbstractDog dog) {
            if (this.cooking.size() >= 10) {
                return;
            }
            List<ItemEntity> checkingItems = this.getRandomNearbyItemEntities(dog);
            for (ItemEntity e : checkingItems) {
                ItemStack item;
                SmeltingRecipe recipe;
                if (this.cooking.size() >= 10) break;
                if (this.cooking.containsKey(e) || (recipe = this.getCookedRecipe(dog, item = e.getItem())) == null) continue;
                this.cooking.put(e, recipe.cookingTime());
            }
        }

        private void invalidateCooking(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.isDefeated()) {
                this.cooking.clear();
                return;
            }
            ArrayList<ItemEntity> removeList = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                if (this.stillValidCooking(dog, entry.getKey())) continue;
                removeList.add(entry.getKey());
            }
            for (ItemEntity e : removeList) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCooking(AbstractDog dog) {
            if (dog.level().isClientSide) {
                this.cookAllCookingClient(dog);
            } else {
                this.cookAllCookingServer(dog);
            }
        }

        private void cookAllCookingServer(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            ArrayList<ItemEntity> finished = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                this.finishCooking(dog, entry.getKey());
                finished.add(entry.getKey());
            }
            for (ItemEntity e : finished) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCookingClient(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.getRandom().nextDouble() < 0.1) {
                dog.level().playLocalSound(dog.getX(), dog.getY(), dog.getZ(), SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                ItemEntity e = entry.getKey();
                if (dog.getRandom().nextInt(3) != 0) continue;
                float f1 = (dog.getRandom().nextFloat() * 2.0f - 1.0f) * e.getBbWidth() * 0.5f;
                float f2 = (dog.getRandom().nextFloat() * 2.0f - 1.0f) * e.getBbWidth() * 0.5f;
                dog.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, e.getX() + (double)f1, e.getY(), e.getZ() + (double)f2, 0.0, 0.05, 0.0);
            }
        }

        private void finishCooking(AbstractDog dog, ItemEntity e) {
            ItemStack uncookedItem = e.getItem().copy();
            SmeltingRecipe recipe = this.getCookedRecipe(dog, uncookedItem);
            if (recipe == null) {
                return;
            }
            ItemStack cookedItem = recipe.assemble(new SingleRecipeInput(uncookedItem.copy()), (HolderLookup.Provider)dog.level().registryAccess()).copy();
            ItemEntity cookedItemEntity = new ItemEntity(dog.level(), e.getX(), e.getY(), e.getZ(), cookedItem);
            cookedItemEntity.setDefaultPickUpDelay();
            dog.level().addFreshEntity((Entity)cookedItemEntity);
            uncookedItem.shrink(1);
            if (uncookedItem.isEmpty()) {
                e.discard();
            } else {
                e.setItem(uncookedItem);
            }
        }

        private boolean stillValidCooking(AbstractDog dog, ItemEntity e) {
            double maxDist = (double)(dog.getBbWidth() / 2.0f + 1.0f) + 0.5;
            return e.isAlive() && e.distanceToSqr((Entity)dog) <= maxDist * maxDist;
        }

        private SmeltingRecipe getCookedRecipe(AbstractDog dog, ItemStack stack) {
            if (stack.isEmpty()) {
                return null;
            }
            Item item = stack.getItem();
            RecipeHolder<SmeltingRecipe> firstCheck = this.getCachedRecipeLoc(item);
            Optional pairOptional = ((ServerLevel)dog.level()).recipeAccess().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), dog.level(), firstCheck);
            if (!pairOptional.isPresent()) {
                return null;
            }
            RecipeHolder pair = (RecipeHolder)pairOptional.get();
            ResourceKey res = pair.id();
            SmeltingRecipe recipe = (SmeltingRecipe)pair.value();
            if (res == null || recipe == null) {
                return null;
            }
            this.cacheResult(item, (RecipeHolder<SmeltingRecipe>)pair);
            return recipe;
        }

        private List<ItemEntity> getRandomNearbyItemEntities(AbstractDog dog) {
            int amount = 10;
            List cookingItems = dog.level().getEntitiesOfClass(ItemEntity.class, dog.getBoundingBox().inflate(1.0));
            if (cookingItems.size() <= 10) {
                return cookingItems;
            }
            Collections.shuffle(cookingItems);
            return cookingItems.subList(0, 10);
        }

        private void invalidateCache() {
            this.recipeCache.clear();
        }

        private void cacheResult(Item item, RecipeHolder<SmeltingRecipe> res) {
            if (item == null || res == null) {
                return;
            }
            this.recipeCache.add((Pair<Item, RecipeHolder<SmeltingRecipe>>)Pair.of((Object)item, res));
        }

        @Nullable
        private RecipeHolder<SmeltingRecipe> getCachedRecipeLoc(Item item) {
            for (Pair<Item, RecipeHolder<SmeltingRecipe>> pair : this.recipeCache) {
                if (pair.getLeft() != item) continue;
                return (RecipeHolder)pair.getRight();
            }
            return null;
        }
    }
}

