/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.item.DyeableAccessoryItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Wig
extends DyeableAccessory
implements IAccessoryHasModel {
    public Wig(Supplier<? extends ItemLike> itemIn) {
        super(DoggyAccessoryTypes.HEAD, itemIn);
    }

    @Override
    public byte getRenderLayer() {
        return 1;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this);
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.WIG;
    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public static final List<Supplier<Item>> DISC_LIST = List.of(DoggyItems.MUSIC_DISC_CHOPIN_OP64_NO1);

        public Inst(Accessory typeIn) {
            super(typeIn);
        }

        @Override
        public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
            if (target == null || target.isAlive()) {
                return;
            }
            this.mayDropDisc(dogIn, target);
        }

        public void mayDropDisc(AbstractDog dog, Entity target) {
            float r = dog.getRandom().nextFloat();
            float chance = 0.15f;
            if (r > 0.15f) {
                return;
            }
            int indx = dog.getRandom().nextInt(DISC_LIST.size());
            dog.spawnAtLocation((ServerLevel)dog.level(), new ItemStack((ItemLike)DISC_LIST.get(indx).get()), 0.0f);
        }
    }

    public static class WigItem
    extends DyeableAccessoryItem {
        public WigItem(Supplier<? extends DyeableAccessory> accessoryIn, Item.Properties properties) {
            super(accessoryIn, properties);
        }

        @Override
        public int getDefaultColor(ItemStack stack) {
            return -14409443;
        }
    }
}

