/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogAllowSleepOnGoal
extends Goal {
    private final Dog dog;
    private int timeout = 60;
    private int sitUpTime = 0;
    private boolean isRestingPeriod = false;

    public DogAllowSleepOnGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        DogSleepOnManager.PerDog sleep_on_manger = this.dog.sleepOnManager;
        if (!sleep_on_manger.isSleepOnRequested()) {
            return false;
        }
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.isOnFire()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return DogSleepOnManager.getServer(this.dog.level()).isSleepCondition(this.dog).ok();
    }

    public boolean canContinueToUse() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.isInSittingPose()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (!DogSleepOnManager.getServer(this.dog.level()).isSleepCondition(this.dog).ok()) {
            return false;
        }
        return this.sitUpTime >= 0;
    }

    public void start() {
        this.timeout = DogAnimation.LIE_SIDEWAY_LOOP.getLengthTicks() * 3;
        this.isRestingPeriod = true;
        this.sitUpTime = DogAnimation.LIE_SIDEWAY_END.getLengthTicks();
        this.dog.setAnimForIdle(DogAnimation.LIE_SIDEWAY_START);
        this.dog.sleepOnManager.setSleepOnReady(true);
    }

    public void stop() {
        DogAnimation anim = this.dog.getAnim();
        if (!anim.interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        DogSleepOnManager.onSleepGoalStop(this.dog);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        if (this.isRestingPeriod) {
            if (this.dog.getAnim() == DogAnimation.LIE_SIDEWAY_START && this.dog.animationManager.isHolding() || this.dog.getAnim() == DogAnimation.NONE) {
                this.dog.setAnim(DogAnimation.LIE_SIDEWAY_LOOP);
            }
        } else {
            --this.sitUpTime;
        }
        if (this.isRestingPeriod) {
            this.updateRestingPeriod();
        }
    }

    private void updateRestingPeriod() {
        boolean finished;
        boolean is_sleeping_on = this.dog.getSleepOnState().is_sleeping();
        this.timeout = !is_sleeping_on ? Math.max(0, this.timeout - 1) : 60;
        boolean bl = finished = !is_sleeping_on && this.timeout <= 0;
        if (finished) {
            this.isRestingPeriod = false;
            this.dog.setAnim(DogAnimation.LIE_SIDEWAY_END);
            this.dog.sleepOnManager.onSleepOnGoalStop();
            return;
        }
    }
}

