/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.RingSearchIterator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class DogFindWaterGoal
extends Goal {
    private static final int SEARCH_RANGE = 6;
    private Dog dog;
    private int searchAgainAt;
    private int holdTime;
    private BlockPos waterPos;
    private Path tempPath;

    public DogFindWaterGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.dog.fireImmune()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (!this.dog.isOnFire()) {
            return false;
        }
        this.waterPos = null;
        if (this.dog.tickCount >= this.searchAgainAt) {
            this.searchAgainAt = this.dog.tickCount + 10;
            this.waterPos = this.searchForWaterPos();
        }
        if (this.waterPos == null) {
            return false;
        }
        Path path = this.dog.getNavigation().createPath(this.waterPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.waterPos, 1, 1)) {
            this.searchAgainAt = this.dog.tickCount + 20;
            return false;
        }
        this.tempPath = path;
        return true;
    }

    public boolean canContinueToUse() {
        if (!this.dog.isOnFire()) {
            return false;
        }
        if (this.waterPos == null) {
            return false;
        }
        return this.holdTime > 0;
    }

    public void start() {
        this.dog.getNavigation().moveTo(this.tempPath, (double)this.dog.getUrgentSpeedModifier());
        this.tempPath = null;
        this.holdTime = 5;
    }

    public void stop() {
        this.tempPath = null;
        this.waterPos = null;
    }

    public void tick() {
        PathNavigation nav = this.dog.getNavigation();
        if (this.waterPos != null && !this.isWaterPos(this.waterPos)) {
            this.waterPos = null;
        }
        if (nav.isDone()) {
            if (this.holdTime == 5 && this.waterPos != null && nav.isDone() && this.dog.blockPosition().distSqr((Vec3i)this.waterPos) <= 1.0) {
                this.dog.getMoveControl().setWantedPosition((double)this.waterPos.getX() + 0.5, (double)this.waterPos.getY(), (double)this.waterPos.getZ() + 0.5, 1.0);
            }
            --this.holdTime;
        }
    }

    private BlockPos searchForWaterPos() {
        for (BlockPos pos : RingSearchIterator.createWithRandom(this.dog.blockPosition(), 4, 6, true, this.dog.getRandom())) {
            if (!this.isWaterPos(pos)) continue;
            return pos;
        }
        return null;
    }

    private boolean isWaterPos(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (this.dog.level().getFluidState(pos).is(FluidTags.WATER)) {
            return true;
        }
        return this.dog.level().isRainingAt(pos);
    }
}

