/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class DogRandomStrollGoal
extends RandomStrollGoal {
    private Dog dog;

    public DogRandomStrollGoal(Dog dog, double speedModifier) {
        super((PathfinderMob)dog, speedModifier);
        this.dog = dog;
    }

    public boolean canUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        if (this.dog.randomStrollCooldown > 0) {
            return false;
        }
        if (this.dog.isOnFire() && this.dog.getRandom().nextFloat() < 0.1f) {
            this.forceTrigger = true;
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        if (!this.dog.isDoingFine()) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void tick() {
        super.tick();
        if (this.dog.avoidGoInFrontOfOwnerManager.isActive() && DogUtil.pathGoingInFrontOfOwner(this.dog)) {
            this.stop();
        }
    }

    @Nullable
    protected Vec3 getPosition() {
        boolean underwater_random;
        boolean bl = underwater_random = this.dog.isInWater() && this.dog.canSwimUnderwater() && this.dog.isDogSwimming();
        if (underwater_random) {
            return BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.dog, (int)10, (int)7);
        }
        return this.getDogWaterAvoidRandomPos();
    }

    private Vec3 getDogWaterAvoidRandomPos() {
        if (this.dog.isInWater()) {
            Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.dog, (int)15, (int)7);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.dog.getRandom().nextFloat() >= 0.001f ? LandRandomPos.getPos((PathfinderMob)this.dog, (int)10, (int)7) : super.getPosition();
    }
}

