/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogSitWhenOrderedGoal
extends Goal {
    Dog dog;
    private boolean ownerOffline;

    public DogSitWhenOrderedGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.dog.isPassenger()) {
            return true;
        }
        if (!this.dog.forceSit() && this.dog.dogAi.isActionBlockingSit()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (this.dog.isInWater()) {
            return false;
        }
        return this.dog.isOrderedToSit() || this.dog.getOwner() == null;
    }

    public void start() {
        this.dog.dogAi.clearTriggerableAction();
        this.ownerOffline = this.dog.getOwner() == null;
        this.dog.getNavigation().stop();
        this.dog.setInSittingPose(true);
        this.dog.clearDogSitOverridePos();
    }

    public boolean canContinueToUse() {
        if (this.dog.isPassenger()) {
            return true;
        }
        if (this.dog.fallDistance > 3.0) {
            return false;
        }
        if (this.dog.isOrderedToSit()) {
            return true;
        }
        if (this.ownerOffline) {
            this.ownerOffline = this.dog.getOwner() == null;
        }
        return this.ownerOffline;
    }

    public void stop() {
        this.dog.setInSittingPose(false);
    }

    public void tick() {
        if (!this.dog.isInSittingPose() && this.dog.getAnim() == DogAnimation.NONE) {
            this.dog.setInSittingPose(true);
        }
    }
}

