/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.phys.Vec3;

public class DogWanderGoal
extends Goal {
    protected final Dog dog;
    protected final double speed;
    protected int executionChance;

    public DogWanderGoal(Dog dogIn, double speedIn) {
        this.dog = dogIn;
        this.speed = speedIn;
        this.executionChance = 60;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.dog.isTame() || this.dog.isVehicle()) {
            return false;
        }
        if (!this.dog.isMode(DogMode.WANDERING)) {
            return false;
        }
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        if (!bowlPos.isPresent()) {
            return false;
        }
        return bowlPos.get().distSqr((Vec3i)this.dog.blockPosition()) < 400.0;
    }

    public void tick() {
        if (this.dog.getNoActionTime() >= 100) {
            return;
        }
        if (this.dog.getRandom().nextInt(this.executionChance) != 0) {
            return;
        }
        if (this.dog.isPathFinding()) {
            return;
        }
        Vec3 pos = this.getPosition();
        this.dog.getNavigation().moveTo(pos.x, pos.y, pos.z, this.speed);
    }

    @Nullable
    protected Vec3 getPosition() {
        PathNavigation pathNavigate = this.dog.getNavigation();
        RandomSource random = this.dog.getRandom();
        int xzRange = 5;
        int yRange = 3;
        float bestWeight = Float.MIN_VALUE;
        Optional<BlockPos> bowlPos = this.dog.getBowlPos();
        BlockPos bestPos = bowlPos.get();
        for (int attempt = 0; attempt < 5; ++attempt) {
            float weight;
            int l = random.nextInt(2 * xzRange + 1) - xzRange;
            int i1 = random.nextInt(2 * yRange + 1) - yRange;
            int j1 = random.nextInt(2 * xzRange + 1) - xzRange;
            BlockPos testPos = bowlPos.get().offset(l, i1, j1);
            if (!pathNavigate.isStableDestination(testPos) || !((weight = this.dog.getWalkTargetValue(testPos)) > bestWeight)) continue;
            bestWeight = weight;
            bestPos = testPos;
        }
        return new Vec3((double)bestPos.getX(), (double)bestPos.getY(), (double)bestPos.getZ());
    }
}

