/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.CompoundTag_1_21_7;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class DogArrow
extends AbstractArrow {
    private static final int NULL_COLOR = -1;
    private static final EntityDataAccessor<Integer> EFFECT_COLOR = SynchedEntityData.defineId(DogArrow.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_SPECTRAL = SynchedEntityData.defineId(DogArrow.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Optional<UUID> dogOwnerUUID = Optional.empty();

    public DogArrow(EntityType<DogArrow> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_);
    }

    public DogArrow(Level p_36861_, AbstractDog dog, ItemStack stack, ItemStack proj_stack) {
        super(DoggyEntityTypes.DOG_ARROW_PROJ.get(), (LivingEntity)dog, p_36861_, stack, proj_stack);
        LivingEntity owner;
        this.updateColor();
        if (stack.is(Items.SPECTRAL_ARROW)) {
            this.entityData.set(IS_SPECTRAL, (Object)true);
        }
        if ((owner = dog.getOwner()) != null) {
            this.dogOwnerUUID = Optional.ofNullable(owner.getUUID());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326324_) {
        super.defineSynchedData(p_326324_);
        p_326324_.define(EFFECT_COLOR, (Object)-1);
        p_326324_.define(IS_SPECTRAL, (Object)false);
    }

    private PotionContents getPotionContents() {
        return (PotionContents)this.getPickupItemStackOrigin().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
    }

    private boolean hasPotionContents() {
        PotionContents data = this.getPotionContents();
        return data != PotionContents.EMPTY;
    }

    private void clearPotionContents() {
        this.setPickupItemStack(new ItemStack((ItemLike)Items.ARROW));
    }

    protected void setPickupItemStack(ItemStack p_331667_) {
        super.setPickupItemStack(p_331667_);
        this.updateColor();
    }

    private void updateColor() {
        int update_color = -1;
        if (this.hasPotionContents()) {
            update_color = this.getPotionContents().getColor();
        }
        this.entityData.set(EFFECT_COLOR, (Object)update_color);
    }

    public void tick() {
        super.tick();
        if (this.isDogSpectralArrow()) {
            this.updateSpectralArrow();
        } else if (this.level().isClientSide) {
            this.makeClientArrowParticle();
        } else {
            this.updateEffectTimeout();
        }
    }

    private void makeClientArrowParticle() {
        int color = this.getColor();
        if (this.isInGround()) {
            if (this.inGroundTime % 5 == 0) {
                this.makeParticle(1, color);
            }
        } else {
            this.makeParticle(2, color);
        }
    }

    private void updateEffectTimeout() {
        boolean effect_expired;
        boolean bl = effect_expired = this.isInGround() && this.inGroundTime >= 600 && this.hasPotionContents();
        if (effect_expired) {
            this.clearPotionContents();
        }
    }

    private void updateSpectralArrow() {
        if (this.level().isClientSide && !this.isInGround()) {
            this.level().addParticle((ParticleOptions)SpellParticleOption.create((ParticleType)ParticleTypes.EFFECT, (int)-1, (float)1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    private void makeParticle(int amount, int color) {
        if (color == -1 || amount <= 0) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(EFFECT_COLOR);
    }

    public boolean isDogSpectralArrow() {
        return (Boolean)this.entityData.get(IS_SPECTRAL);
    }

    protected void doPostHurtEffects(LivingEntity target) {
        super.doPostHurtEffects(target);
        if (this.isDogSpectralArrow()) {
            this.doDogSpectralArrowEffectHurt(target);
        } else {
            this.doNormalDogArrowEffectHurt(target);
        }
        this.killCreeperIfCreeperSweeper(target);
    }

    private void doNormalDogArrowEffectHurt(LivingEntity target) {
        Entity effect_source = this.getEffectSource();
        PotionContents potion_contents = this.getPotionContents();
        if (potion_contents.potion().isPresent()) {
            for (MobEffectInstance effect_inst : ((Potion)((Holder)potion_contents.potion().get()).value()).getEffects()) {
                target.addEffect(new MobEffectInstance(effect_inst.getEffect(), Math.max(effect_inst.mapDuration(x -> x / 8), 1), effect_inst.getAmplifier(), effect_inst.isAmbient(), effect_inst.isVisible()), effect_source);
            }
        }
        for (MobEffectInstance custom_effect_inst : potion_contents.customEffects()) {
            target.addEffect(custom_effect_inst, effect_source);
        }
    }

    private void doDogSpectralArrowEffectHurt(LivingEntity target) {
        MobEffectInstance glow_inst = new MobEffectInstance(MobEffects.GLOWING, 200, 0);
        target.addEffect(glow_inst, this.getEffectSource());
    }

    private void killCreeperIfCreeperSweeper(LivingEntity target) {
        Entity owner = this.getOwner();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)target;
        creeper.setHealth(0.0f);
        creeper.die(dog.damageSources().mobAttack((LivingEntity)dog));
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected boolean tryPickup(Player picker) {
        if (this.shouldDogArrowBlockPickup(picker)) {
            return false;
        }
        return super.tryPickup(picker);
    }

    private boolean shouldDogArrowBlockPickup(Player picker) {
        if (picker.isCreative()) {
            return false;
        }
        if (!this.dogOwnerUUID.isPresent()) {
            return false;
        }
        return !this.dogOwnerUUID.get().equals(picker.getUUID());
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        this.dogOwnerUUID.ifPresent(x -> CompoundTag_1_21_7.wrap(tag).putUUID("dtn_dog_owner_id", (UUID)x));
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        if (CompoundTag_1_21_5.wrap(tag).hasUUID("dtn_dog_owner_id")) {
            UUID uuid = CompoundTag_1_21_5.wrap(tag).getUUID("dtn_dog_owner_id");
            this.dogOwnerUUID = Optional.ofNullable(uuid);
        }
    }
}

