/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.stats;

import com.google.common.collect.Maps;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.common.backward_imitate.NBTUtil_1_21_7;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class StatsTracker {
    private Map<EntityType<?>, Integer> ENTITY_KILLS = Maps.newHashMap();
    private float damageDealt = 0.0f;
    private int distanceOnWater = 0;
    private int distanceInWater = 0;
    private int distanceSprinting = 0;
    private int distanceSneaking = 0;
    private int distanceWalking = 0;
    private int distanceRidden = 0;
    private final Cache<Integer> killCount = Cache.make(this::getTotalKillCountInternal);

    public void writeAdditional(CompoundTag compound) {
        ListTag killList = new ListTag();
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            CompoundTag stats = new CompoundTag();
            NBTUtil_1_21_7.putRegistryValue(stats, "type", BuiltInRegistries.ENTITY_TYPE.getKey(entry.getKey()));
            stats.putInt("count", entry.getValue().intValue());
            killList.add((Object)stats);
        }
        compound.put("entityKills", (Tag)killList);
        compound.putDouble("damageDealt", (double)this.damageDealt);
        compound.putInt("distanceOnWater", this.distanceOnWater);
        compound.putInt("distanceInWater", this.distanceInWater);
        compound.putInt("distanceSprinting", this.distanceSprinting);
        compound.putInt("distanceSneaking", this.distanceSneaking);
        compound.putInt("distanceWalking", this.distanceWalking);
        compound.putInt("distanceRidden", this.distanceRidden);
    }

    public void readAdditional(CompoundTag_1_21_5 compound) {
        ListTag_1_21_5 killList = compound.getList("entityKills", 10);
        for (int i = 0; i < killList.size(); ++i) {
            CompoundTag_1_21_5 stats = killList.getCompound(i);
            EntityType type = (EntityType)NBTUtil.getRegistryValue(stats, "type", BuiltInRegistries.ENTITY_TYPE);
            this.ENTITY_KILLS.put(type, stats.getInt("count"));
        }
        this.damageDealt = compound.getFloat("damageDealt");
        this.distanceOnWater = compound.getInt("distanceOnWater");
        this.distanceInWater = compound.getInt("distanceInWater");
        this.distanceSprinting = compound.getInt("distanceSprinting");
        this.distanceSneaking = compound.getInt("distanceSneaking");
        this.distanceWalking = compound.getInt("distanceWalking");
        this.distanceRidden = compound.getInt("distanceRidden");
    }

    public int getKillCountFor(EntityType<?> type) {
        return this.ENTITY_KILLS.getOrDefault(type, 0);
    }

    public int getKillCountFor(Predicate<MobCategory> classification) {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            if (!classification.test(entry.getKey().getCategory())) continue;
            total += entry.getValue().intValue();
        }
        return total;
    }

    private int getTotalKillCountInternal() {
        int total = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public Map<EntityType<?>, Integer> getAllKillCount() {
        return Collections.unmodifiableMap(this.ENTITY_KILLS);
    }

    public int getTotalKillCount() {
        return this.killCount.get();
    }

    public void incrementKillCount(Entity entity) {
        this.incrementKillCount(entity.getType());
    }

    private void incrementKillCount(EntityType<?> type) {
        this.ENTITY_KILLS.compute(type, (k, v) -> (v == null ? 0 : v) + 1);
    }

    public void increaseDamageDealt(float damage) {
        this.damageDealt += damage;
    }

    public void increaseDistanceOnWater(int distance) {
        this.distanceOnWater += distance;
    }

    public void increaseDistanceInWater(int distance) {
        this.distanceInWater += distance;
    }

    public void increaseDistanceSprint(int distance) {
        this.distanceSprinting += distance;
    }

    public void increaseDistanceSneaking(int distance) {
        this.distanceSneaking += distance;
    }

    public void increaseDistanceWalk(int distance) {
        this.distanceWalking += distance;
    }

    public void increaseDistanceRidden(int distance) {
        this.distanceRidden += distance;
    }

    public float getDamageDealt() {
        return this.damageDealt;
    }

    public int getDistanceOnWater() {
        return this.distanceOnWater;
    }

    public int getDistanceInWater() {
        return this.distanceInWater;
    }

    public int getDistanceSprint() {
        return this.distanceSprinting;
    }

    public int getDistanceSneaking() {
        return this.distanceSneaking;
    }

    public int getDistanceWalk() {
        return this.distanceWalking;
    }

    public int getDistanceRidden() {
        return this.distanceRidden;
    }

    public void clearAllStatsKill() {
        this.ENTITY_KILLS.clear();
    }

    public void serializeToBuf(FriendlyByteBuf buf) {
        buf.writeFloat(this.damageDealt);
        buf.writeInt(this.distanceOnWater);
        buf.writeInt(this.distanceInWater);
        buf.writeInt(this.distanceSprinting);
        buf.writeInt(this.distanceSneaking);
        buf.writeInt(this.distanceWalking);
        buf.writeInt(this.distanceRidden);
        int mapSize = this.ENTITY_KILLS.size();
        buf.writeInt(mapSize);
        for (Map.Entry<EntityType<?>, Integer> entry : this.ENTITY_KILLS.entrySet()) {
            ResourceLocation typeId = BuiltInRegistries.ENTITY_TYPE.getKey(entry.getKey());
            Integer killCount = entry.getValue();
            buf.writeResourceLocation(typeId);
            buf.writeInt(killCount.intValue());
        }
    }

    public void deserializeFromBuf(FriendlyByteBuf buf) {
        this.damageDealt = buf.readFloat();
        this.distanceOnWater = buf.readInt();
        this.distanceInWater = buf.readInt();
        this.distanceSprinting = buf.readInt();
        this.distanceSneaking = buf.readInt();
        this.distanceWalking = buf.readInt();
        this.distanceRidden = buf.readInt();
        this.ENTITY_KILLS.clear();
        int mapSize = buf.readInt();
        for (int i = 0; i < mapSize; ++i) {
            ResourceLocation typeId = buf.readResourceLocation();
            int killCount = buf.readInt();
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(typeId);
            this.ENTITY_KILLS.put(type, killCount);
        }
    }

    public void shallowCopyFrom(StatsTracker stats) {
        this.ENTITY_KILLS = stats.ENTITY_KILLS;
        this.damageDealt = stats.damageDealt;
        this.distanceOnWater = stats.distanceOnWater;
        this.distanceInWater = stats.distanceInWater;
        this.distanceSprinting = stats.distanceSprinting;
        this.distanceSneaking = stats.distanceSneaking;
        this.distanceWalking = stats.distanceWalking;
        this.distanceRidden = stats.distanceRidden;
    }
}

