/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class DoggyToolsMenu
extends AbstractContainerMenu {
    private Dog dog;
    private DoggyToolsItemHandler tools;
    private int beginToolsIndx = -1;
    private int toolsSize;

    public DoggyToolsMenu(int windowId, Inventory playerInventory, Dog dog) {
        super(DoggyContainerTypes.DOG_TOOLS.get(), windowId);
        this.dog = dog;
        Optional<DoggyToolsTalent> talent = dog.getTalent(DoggyTalents.DOGGY_TOOLS).map(inst -> inst.cast(DoggyToolsTalent.class));
        if (!talent.isPresent()) {
            return;
        }
        DoggyToolsItemHandler dogTools = talent.map(inst -> inst.getTools()).orElse(null);
        if (dogTools == null) {
            return;
        }
        this.tools = dogTools;
        for (int j = 0; j < 3; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInventory, i1 + j * 9 + 9, 8 + i1 * 18, 45 + j * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 103));
        }
        this.beginToolsIndx = this.slots.size();
        int mX = 90;
        int aY = 23;
        this.toolsSize = DoggyToolsTalent.getSize(talent.map(inst -> inst.level()).orElse(0));
        int toolsSlotsOffsetX = this.toolsSize / 2 * 18 + this.toolsSize % 2 * 9;
        int pX = mX - toolsSlotsOffsetX;
        for (int i = 0; i < this.toolsSize; ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.tools, i, pX, aY));
            pX += 18;
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.beginToolsIndx ? !this.moveItemStackTo(itemstack1, 0, this.beginToolsIndx, true) : !this.moveItemStackTo(itemstack1, this.beginToolsIndx, this.slots.size(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        int toolsLevel = this.dog.getDogLevel(DoggyTalents.DOGGY_TOOLS.get());
        if (toolsLevel <= 0) {
            return false;
        }
        if (this.getToolsSize() != DoggyToolsTalent.getSize(toolsLevel)) {
            return false;
        }
        return this.dog.isDoingFine();
    }

    public int getToolsSize() {
        return this.toolsSize;
    }
}

