/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.screen.DogAnimDebugScreen;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DogAnimDebugItem
extends Item
implements IDogItem,
HoverTextAppender_1_21_5 {
    public static final String SELECT_ANIM_ID = "dtn_selected_id";
    public static final String ITEM_MODE_ID = "dtn_item_mode";

    public DogAnimDebugItem(Item.Properties p_41383_) {
        super(p_41383_.stacksTo(1));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            DogAnimDebugScreen.open(player);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!dogIn.level().isClientSide) {
            this.useActionOnDog(dogIn, playerIn);
        }
        return DogInteractionResult.SUCCESS;
    }

    private void useActionOnDog(AbstractDog dogIn, Player player) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!player.hasPermissions(4)) {
            return;
        }
        if (!player.isCreative()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != this) {
            return;
        }
        ItemMode item_mode = DogAnimDebugItem.getItemMode(stack);
        DogAnimationManager anim_manager = dog.animationManager;
        switch (item_mode.ordinal()) {
            case 0: {
                if (player.isShiftKeyDown()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimation anim = DogAnimDebugItem.getSelectedAnimation(stack);
                if (anim.isNone()) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.NONE);
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                if (debug_state.anim() != anim) {
                    anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, 0, 0.0f));
                    dog.setAnim(anim);
                    return;
                }
                if (dog.getAnim().isNone()) {
                    dog.setAnim(anim);
                } else {
                    anim_manager.setDogAnimDebugState(dog.animationManager.getFreezeDebugState(anim));
                    dog.setAnim(DogAnimation.NONE);
                }
                return;
            }
            case 1: {
                if (!dog.isDogInAnimDebug()) {
                    return;
                }
                DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
                DogAnimation anim = debug_state.anim();
                if (anim.isNone()) {
                    return;
                }
                int new_timestamp = debug_state.timestamp() + (player.isShiftKeyDown() ? -1 : 1);
                new_timestamp = Mth.clamp((int)new_timestamp, (int)0, (int)anim.getLengthTicks());
                anim_manager.setDogAnimDebugState(DogAnimationManager.DogAnimDebugState.of(anim, new_timestamp, debug_state.yRot()));
                return;
            }
            case 2: {
                anim_manager.setDebugFreezeYRot(player.yHeadRot);
                return;
            }
        }
    }

    public boolean isFoil(ItemStack p_41453_) {
        return true;
    }

    public static DogAnimation getSelectedAnimation(ItemStack stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains(SELECT_ANIM_ID, 3)) {
            return DogAnimation.NONE;
        }
        int anim_id = tag.getInt(SELECT_ANIM_ID);
        DogAnimation anim = DogAnimation.byId(anim_id);
        return anim;
    }

    public static ItemMode getItemMode(ItemStack stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains(ITEM_MODE_ID, 3)) {
            return ItemMode.ANIM;
        }
        int mode_id = tag.getInt(ITEM_MODE_ID);
        ItemMode mode = ItemMode.fromId(mode_id);
        return mode;
    }

    public static void editDebugAnimStack(ItemStack stack, @Nullable DogAnimation selected, @Nullable ItemMode mode) {
        if (stack.getItem() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (selected != null) {
            tag.putInt(SELECT_ANIM_ID, selected.getId());
        }
        if (mode != null) {
            tag.putInt(ITEM_MODE_ID, mode.getId());
        }
        ItemUtil.putTag(stack, tag);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = "item.doggytalents.dog_anim_debug_stick.help";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }

    public static enum ItemMode {
        ANIM(0),
        TIME_SET(1),
        YROT(2);

        private final int id;

        private ItemMode(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ItemMode fromId(int id) {
            ItemMode[] values = ItemMode.values();
            if (id < 0 || id >= values.length) {
                return ANIM;
            }
            return values[id];
        }

        public ItemMode cycleMode() {
            ItemMode[] modes = ItemMode.values();
            int current_id = this.getId();
            int new_id = current_id + 1;
            if (new_id >= modes.length) {
                new_id = 0;
            }
            ItemMode new_mode = ItemMode.fromId(new_id);
            return new_mode;
        }
    }
}

