/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DogPlushieItem
extends Item
implements IDyeableArmorItem,
IDogItem,
HoverTextAppender_1_21_5 {
    public DogPlushieItem(Item.Properties itemProps) {
        super(itemProps.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        BlockPos spawnAt = state.getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : pos.relative(face);
        DogPlushie plush = (DogPlushie)DoggyEntityTypes.DOG_PLUSHIE_TOY.get().create((ServerLevel)level, null, spawnAt, EntitySpawnReason.TRIGGERED, !Objects.equals(pos, spawnAt) && face == Direction.UP, false);
        if (plush != null) {
            plush.setYRot(face.getOpposite().toYRot());
            int color = ItemUtil.getDyeColorForStack(stack);
            plush.setCollarColor(color);
            DogVariant variant = DogPlushieItem.getDogVariant(stack);
            plush.setDogVariant(variant);
            boolean collar_thicc = DogPlushieItem.getCollarThicc(stack);
            plush.setCollarThicc(collar_thicc);
            level.addFreshEntity((Entity)plush);
        }
        if (player != null && !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (player != null) {
            PlayerUtil.addCooldown(player, this, 20);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        boolean is_thicc_collar;
        if (context.level() == null) {
            return;
        }
        String desc_id = "item.doggytalents.dog_plushie_toy_item.description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        DogVariant variant = DogPlushieItem.getDogVariant(stack);
        if (variant != DogVariantUtil.getDefault() && context.level().isClientSide) {
            String variant_str = Component.translatable((String)"doggui.classical.variant").getString() + " " + ClientEventHandler.getTranslatedVariantStr(variant);
            MutableComponent variant_c1 = Component.literal((String)variant_str).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(variant.guiColor()));
            components.add((Component)variant_c1);
        }
        if (is_thicc_collar = DogPlushieItem.getCollarThicc(stack)) {
            components.add((Component)Component.translatable((String)DoggyItems.WOOL_COLLAR_THICC.get().getDescriptionId()).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        }
    }

    @Override
    public int getDefaultColor(ItemStack stack) {
        return 11546150;
    }

    public static void setDogVariant(ItemStack stack, DogVariant variant) {
        if (stack.getItem() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        tag.putString("dogVariant", DogVariantUtil.toSaveString(variant));
        ItemUtil.putTag(stack, tag);
    }

    public static DogVariant getDogVariant(ItemStack stack) {
        if (stack.getItem() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return DogVariantUtil.getDefault();
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (!tag.contains("dogVariant", 8)) {
            return DogVariantUtil.getDefault();
        }
        String variant_str = tag.getString("dogVariant");
        return DogVariantUtil.fromSaveString(variant_str);
    }

    public static void setCollarThicc(ItemStack stack, boolean val) {
        if (stack.getItem() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        tag.putBoolean("collarThicc", val);
        ItemUtil.putTag(stack, tag);
    }

    public static boolean getCollarThicc(ItemStack stack) {
        if (stack.getItem() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return false;
        }
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        return tag.getBoolean("collarThicc");
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!(dogIn instanceof Dog)) {
            return DogInteractionResult.PASS;
        }
        Dog dog = (Dog)dogIn;
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (this.copyDogToStack(dog, stack, playerIn.isShiftKeyDown())) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.FAIL;
    }

    private boolean copyDogToStack(Dog dog, ItemStack stack, boolean copy_color) {
        boolean collar_thicc_stack;
        boolean collar_thicc_dog;
        DogVariant variant_stack;
        boolean changed = false;
        DogVariant variant_dog = dog.dogVariant();
        if (variant_dog != (variant_stack = DogPlushieItem.getDogVariant(stack))) {
            if (!dog.level().isClientSide) {
                DogPlushieItem.setDogVariant(stack, variant_dog);
            }
            changed = true;
        }
        if ((collar_thicc_dog = dog.getAccessory(DoggyAccessories.DYEABLE_COLLAR_THICC.get()).isPresent()) != (collar_thicc_stack = DogPlushieItem.getCollarThicc(stack))) {
            if (!dog.level().isClientSide) {
                DogPlushieItem.setCollarThicc(stack, collar_thicc_dog);
            }
            changed = true;
        }
        if (copy_color && this.copyCollarColor(dog, stack)) {
            return true;
        }
        return changed;
    }

    private boolean copyCollarColor(Dog dog, ItemStack stack) {
        int collar_color_stack = ItemUtil.getDyeColorForStack(stack);
        int collar_color_dog = dog.getAccessory(DoggyAccessoryTypes.COLLAR.get()).filter(x -> x instanceof DyeableAccessory.DyeableAccessoryInstance).map(x -> ((DyeableAccessory.DyeableAccessoryInstance)x).getColorInteger()).orElse(this.getDefaultColor(stack));
        if (collar_color_dog == collar_color_stack) {
            return false;
        }
        ItemUtil.setDyeColorForStack(stack, collar_color_dog);
        return true;
    }
}

