/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.AllStandSwitchModeScreen;
import doggytalents.client.screen.CarryMeScreen;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogHowlAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.talent.BedDogTalent;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.talent.doggy_tools.DogBridging;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WhistleItem
extends Item
implements IDogItem,
HoverTextAppender_1_21_5 {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player player, InteractionHand hand) {
        WhistleMode mode;
        ItemStack stack = player.getItemInHand(hand);
        byte id_mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            id_mode = tag.getByte("mode");
        }
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        return (mode = WhistleMode.VALUES[id_mode]) == WhistleMode.MOB_RETRIEVER || mode == WhistleMode.RIDE_WITH_ME || mode == WhistleMode.HOWL || mode == WhistleMode.BED_DOG_WHISTLE ? DogInteractionResult.FAIL : DogInteractionResult.PASS;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (world.isClientSide) {
                WhistleScreen.open(stack);
            }
            return InteractionResult.SUCCESS;
        }
        byte id_mode = 0;
        boolean on_duty_only = false;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            id_mode = tag.getByte("mode");
        }
        on_duty_only = tag.getBoolean("dog_on_duty_only");
        List dogsList = world.getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.isOwnedBy((LivingEntity)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, on_duty_only, dogsList, world, player, hand, false);
        return InteractionResult.SUCCESS;
    }

    public void useMode(WhistleMode mode, boolean dogOnDutyOnly, List<Dog> dogsList, Level world, Player player, InteractionHand hand, boolean isKeyBind) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound().ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                world.playSound(null, player.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + world.random.nextFloat() * 0.1f, 0.8f + world.random.nextFloat() * 0.2f);
                break;
            }
            case 1: {
                world.playSound(null, player.blockPosition(), DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + world.random.nextFloat() * 0.1f, 0.8f + world.random.nextFloat() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode.ordinal()) {
            case 0: {
                if (world.isClientSide) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.setOrderedToSit(false);
                    dog.getNavigation().stop();
                    dog.setTarget(null);
                    successful = true;
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.come"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 1: {
                if (world.isClientSide) {
                    return;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 40);
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                        return false;
                    }
                    if (filter_dog.isOrderedToSit()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.distanceToSqr((Entity)player) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((Entity)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                for (Dog dog : heel_list) {
                    dog.clearTriggerableAction();
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (LivingEntity)player, 3);
                PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.heel"));
                return;
            }
            case 2: {
                if (world.isClientSide) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.setOrderedToSit(true);
                    dog.getNavigation().stop();
                    dog.setTarget(null);
                    successful = true;
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.stay"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 3: {
                if (world.isClientSide) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.setTarget(null);
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.stop_attacking"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 4: {
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 5: {
                if (world.isClientSide) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (LivingEntity)player);
                doggyBeam.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 1.0f);
                world.addFreshEntity((Entity)doggyBeam);
                PlayerUtil.addCooldown(player, this, 10);
                return;
            }
            case 6: {
                Optional<Integer> cooldown_optional = RoaringGaleTalent.roar(dogsList, world, player);
                cooldown_optional.ifPresent(x -> PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), x));
                return;
            }
            case 7: {
                if (world.isClientSide) {
                    HeelByNameScreen.open(isKeyBind ? 200 : 0);
                }
                return;
            }
            case 8: {
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.level().isClientSide) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    BlockPos bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (BlockPos)dog.getBedPos((ResourceKey<Level>)player.level().dimension()).orElse(null)) == null || dog.blockPosition().equals((Object)bedPos) && dog.isInSittingPose() || !(dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                return;
            }
            case 9: {
                if (player.level().isClientSide) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    LivingEntity owner;
                    if (dogOnDutyOnly && !dog.dogOnDuty() || !dog.getMode().shouldFollowOwner() || dog.isOrderedToSit() || (owner = dog.getOwner()) == null || dog.distanceToSqr((Entity)owner) > 400.0) continue;
                    dog.setTarget(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 10: {
                if (world.isClientSide) {
                    HeelByGroupScreen.open();
                }
                return;
            }
            case 11: {
                AABB search_area;
                Vec3 view_vec;
                Vec3 max_reach_vec;
                Vec3 max_pos;
                if (world.isClientSide) {
                    return;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                Optional<Dog> retrieverOptional = MobRetrieverTalent.chooseNearestDog(player, world);
                if (retrieverOptional.isEmpty()) {
                    return;
                }
                Dog retriever = retrieverOptional.get();
                Optional<TalentInstance> talentOptional = retriever.getTalent(DoggyTalents.MOB_RETRIEVER.get());
                if (talentOptional.isEmpty()) {
                    return;
                }
                MobRetrieverTalent talentInst = (MobRetrieverTalent)talentOptional.get();
                int reach_range = MobRetrieverTalent.getSelectTargetRange();
                Vec3 eye_pos = player.getEyePosition();
                EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.add(max_reach_vec = (view_vec = player.getViewVector(1.0f)).scale((double)reach_range))), (AABB)(search_area = player.getBoundingBox().expandTowards(max_reach_vec).inflate(1.0, 1.0, 1.0)), e -> {
                    if (!(e instanceof LivingEntity)) {
                        return false;
                    }
                    LivingEntity living = (LivingEntity)e;
                    return talentInst.isValidTarget(retriever, living);
                }, (double)(reach_range * reach_range));
                if (hitResult == null) {
                    return;
                }
                Entity entity = hitResult.getEntity();
                if (entity == null) {
                    return;
                }
                talentInst.setTarget(retriever, (LivingEntity)entity);
                return;
            }
            case 12: {
                this.heelByLook(world, player);
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 13: {
                this.rideWithMe(world, player);
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 14: {
                this.howl(world, player);
                return;
            }
            case 15: {
                if (world.isClientSide) {
                    AllStandSwitchModeScreen.open(player);
                }
                return;
            }
            case 16: {
                this.sssshhhh(world, player, dogsList);
                return;
            }
            case 17: {
                this.crossOriginTpForDogs(world, player, dogsList);
                return;
            }
            case 18: {
                BedDogTalent.useBedDog(world, player);
                return;
            }
            case 19: {
                this.allStandOnDuty(world, player, dogsList);
                return;
            }
            case 20: {
                if (world.isClientSide) {
                    CarryMeScreen.open(player);
                }
                return;
            }
            case 21: {
                DogBridging.useBridgingWhistle(this, player, world);
                return;
            }
            case 22: {
                this.catchUp(world, player, dogsList, dogOnDutyOnly);
                return;
            }
        }
    }

    private void rideWithMe(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.isPassenger()) {
            dog.unRide();
            return;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle == null) {
            return;
        }
        dog.authorizeRiding();
        boolean result = dog.startRiding(vehicle);
        if (result) {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.ride_with_me", (Object[])new Object[]{dog.getName().getString()}));
        }
    }

    private void heelByLook(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (LivingEntity)player, 2);
        PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.getName().getString()}));
        dog.setOrderedToSit(false);
    }

    private void howl(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30);
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (!dog.readyForNonTrivialAction()) {
            return;
        }
        dog.triggerAction(new DogHowlAction(dog));
        player.level().playSound(null, player.blockPosition(), DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + player.level().random.nextFloat() * 0.1f, 0.8f + player.level().random.nextFloat() * 0.2f);
    }

    private void sssshhhh(Level level, Player player, List<Dog> dogs) {
        if (level.isClientSide) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        boolean shh_ed = false;
        for (Dog dog : dogs) {
            if (!this.canShh(player, dog)) continue;
            shh_ed = true;
            dog.setSilentTickLeft(400);
        }
        if (shh_ed) {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.ssshhh"));
            level.playSound(null, player.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.1f, 0.8f + level.random.nextFloat() * 0.2f);
        }
    }

    private void crossOriginTpForDogs(Level level, Player player, List<Dog> dogs) {
        if (level.isClientSide) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        dogs = dogs.stream().filter(x -> !x.isInSittingPose()).collect(Collectors.toList());
        if (dogs.isEmpty()) {
            return;
        }
        boolean all_cross_origin = true;
        for (Dog dog : dogs) {
            if (dog.crossOriginTp()) continue;
            all_cross_origin = false;
            break;
        }
        boolean switch_to = !all_cross_origin;
        for (Dog dog : dogs) {
            dog.setCrossOriginTp(switch_to);
        }
        if (switch_to) {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.cross_origin.set"));
        } else {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.cross_origin.unset"));
        }
    }

    private void allStandOnDuty(Level level, Player player, List<Dog> dogs) {
        if (level.isClientSide) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        int on_duty_count = 0;
        int not_on_duty_count = 0;
        for (Dog dog : dogs) {
            boolean on_duty_0 = dog.dogOnDuty();
            dog.setDogOnDuty(!dog.isOrderedToSit());
            boolean on_duty = dog.dogOnDuty();
            if (on_duty == on_duty_0) continue;
            if (on_duty) {
                ++on_duty_count;
                continue;
            }
            ++not_on_duty_count;
        }
        if (on_duty_count > 0 || not_on_duty_count > 0) {
            PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.on_duty", (Object[])new Object[]{on_duty_count, not_on_duty_count}));
        }
    }

    private boolean canShh(Player player, Dog dog) {
        return !(dog.distanceToSqr((Entity)player) > 256.0);
    }

    private void catchUp(Level level, Player player, List<Dog> dogs, boolean dogOnDutyOnly) {
        if (level.isClientSide) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 40);
        int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
        List heel_list = dogs.stream().filter(filter_dog -> {
            if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                return false;
            }
            if (filter_dog.isOrderedToSit()) {
                return false;
            }
            if (!filter_dog.getMode().shouldFollowOwner()) {
                return false;
            }
            return filter_dog.distanceToSqr((Entity)player) > 4.0;
        }).collect(Collectors.toList());
        if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
            Collections.sort(heel_list, new EntityUtil.Sorter((Entity)player));
            heel_list = heel_list.subList(0, max_heel_count);
        }
        if (heel_list.isEmpty()) {
            return;
        }
        for (Dog dog : dogs) {
            if (dog.isOrderedToSit() || !dog.getMode().shouldFollowOwner()) continue;
            dog.dogAi.clearTriggerableAction();
            dog.dogAi.requestFollow();
        }
        PlayerUtil.sendSystemMessage((LivingEntity)player, (Component)Component.translatable((String)"dogcommand.catchup"));
    }

    public static boolean isDogOnDutyOnly(ItemStack stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        return tag.getBoolean("dog_on_duty_only");
    }

    public static boolean isHoldingDutyWhistle(LivingEntity entity) {
        ItemStack stack = entity.getMainHandItem();
        if (!stack.is((Item)DoggyItems.WHISTLE.get())) {
            return false;
        }
        int mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            mode = (byte)Mth.clamp((int)tag.getByte("mode"), (int)0, (int)(WhistleMode.VALUES.length - 1));
        }
        return WhistleMode.VALUES[mode] == WhistleMode.DUTY_WHISTLE;
    }

    public Component getName(ItemStack stack) {
        byte mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            mode = tag.getByte("mode");
        }
        return Component.translatable((String)(this.getDescriptionId() + "." + mode));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flags) {
        String desc_id = this.getDescriptionId() + ".description";
        components.add((Component)Component.translatable((String)desc_id).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        STOP_ATTACKING(3, WhistleSound.SHORT),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE),
        MOB_RETRIEVER(11, WhistleSound.SHORT),
        HEEL_BY_LOOK(12, WhistleSound.SHORT),
        RIDE_WITH_ME(13, WhistleSound.SHORT),
        HOWL(14, WhistleSound.NONE),
        ALL_STAND_SWITCH_MODE(15, WhistleSound.NONE),
        SSSSSHHHH(16, WhistleSound.NONE),
        CROSS_ORIGIN_TP(17, WhistleSound.SHORT),
        BED_DOG_WHISTLE(18, WhistleSound.NONE),
        DUTY_WHISTLE(19, WhistleSound.SHORT),
        CARRY_ME(20, WhistleSound.NONE),
        BRIDING(21, WhistleSound.NONE),
        CATCH_UP(22, WhistleSound.SHORT);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        public String getHelpMsg() {
            return this.getUnlocalisedTitle() + ".help";
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

