/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogRegardTeamPlayersData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;

public class DogRegardTeamPlayersPacket
extends DogPacket<DogRegardTeamPlayersData> {
    @Override
    public void encode(DogRegardTeamPlayersData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.regardTeamPlayers);
    }

    @Override
    public DogRegardTeamPlayersData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean regardTeamPlayers = buf.readBoolean();
        return new DogRegardTeamPlayersData(entityId, regardTeamPlayers);
    }

    @Override
    public void handleDog(Dog dogIn, DogRegardTeamPlayersData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dogIn.setRegardTeamPlayers(data.regardTeamPlayers);
    }
}

