/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.ForceClearKillStatsData;
import doggytalents.common.util.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ForceClearKillStatsPacket
extends DogPacket<ForceClearKillStatsData> {
    @Override
    public void encode(ForceClearKillStatsData data, FriendlyByteBuf buf) {
        buf.writeInt(data.entityId);
    }

    @Override
    public ForceClearKillStatsData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        return new ForceClearKillStatsData(id);
    }

    @Override
    public void handleDog(Dog dogIn, ForceClearKillStatsData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ServerPlayer sender = ctx.get().getSender();
        if (!sender.hasPermissions(4)) {
            return;
        }
        if (!sender.getAbilities().instabuild) {
            return;
        }
        ItemStack stack = sender.getMainHandItem();
        if (!stack.is(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        if (PlayerUtil.isOnCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        dogIn.getStatTracker().clearAllStatsKill();
        PlayerUtil.addCooldown((Player)sender, DoggyItems.AMNESIA_BONE.get(), 20);
    }
}

