/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HeelByGroupPackets {

    public static class REQUEST_HEEL
    implements IPacket<HeelByGroupData.REQUEST_HEEL> {
        @Override
        public void encode(HeelByGroupData.REQUEST_HEEL data, FriendlyByteBuf buf) {
            buf.writeBoolean(data.heelAndSit);
            DogGroupsManager.DogGroup group = data.group;
            buf.writeInt(group.color);
            buf.writeUtf(group.name, 16);
        }

        @Override
        public HeelByGroupData.REQUEST_HEEL decode(FriendlyByteBuf buf) {
            boolean heelAndSit = buf.readBoolean();
            int color = buf.readInt();
            String name = buf.readUtf(16);
            return new HeelByGroupData.REQUEST_HEEL(new DogGroupsManager.DogGroup(name, color), heelAndSit);
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_HEEL data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                if (PlayerUtil.isOnCooldown((Player)sender, DoggyItems.WHISTLE.get())) {
                    return;
                }
                List dogs = sender.level().getEntitiesOfClass(Dog.class, sender.getBoundingBox().inflate(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.isOwnedBy((LivingEntity)sender) && dog.getGroups().isGroup(data.group));
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                if (max_heel_count > 0 && dogs.size() > max_heel_count) {
                    Collections.sort(dogs, new EntityUtil.Sorter((Entity)sender));
                    dogs = dogs.subList(0, max_heel_count);
                }
                for (Dog dog2 : dogs) {
                    if (dog2.isPassenger()) {
                        dog2.stopRiding();
                    }
                    dog2.clearTriggerableAction();
                    dog2.setOrderedToSit(data.heelAndSit);
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch((Level)sender.level(), dogs, (LivingEntity)sender, 3);
                sender.level().playSound(null, sender.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + sender.level().random.nextFloat() * 0.1f, 0.4f + sender.level().random.nextFloat() * 0.2f);
                PlayerUtil.sendSystemMessage((LivingEntity)sender, (Component)Component.translatable((String)"dogcommand.heel_by_group", (Object[])new Object[]{Component.literal((String)data.group.name).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(data.group.color))}));
                PlayerUtil.addCooldown((Player)sender, DoggyItems.WHISTLE.get(), 40);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RESPONSE_GROUP_LIST
    implements IPacket<HeelByGroupData.RESPONSE_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.RESPONSE_GROUP_LIST data, FriendlyByteBuf buf) {
            int size = data.groups.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                DogGroupsManager.DogGroup group = data.groups.get(i);
                buf.writeInt(group.color);
                buf.writeUtf(group.name, 16);
            }
        }

        @Override
        public HeelByGroupData.RESPONSE_GROUP_LIST decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<DogGroupsManager.DogGroup> groups = new ArrayList<DogGroupsManager.DogGroup>(size);
            for (int i = 0; i < size; ++i) {
                int color = buf.readInt();
                String name = buf.readUtf(16);
                groups.add(new DogGroupsManager.DogGroup(name, color));
            }
            return new HeelByGroupData.RESPONSE_GROUP_LIST(groups);
        }

        @Override
        public void handle(HeelByGroupData.RESPONSE_GROUP_LIST data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Screen screen = mc.screen;
                    if (screen instanceof HeelByGroupScreen) {
                        HeelByGroupScreen groupScreen = (HeelByGroupScreen)screen;
                        groupScreen.assignResponse(data.groups);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class REQUEST_GROUP_LIST
    implements IPacket<HeelByGroupData.REQUEST_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.REQUEST_GROUP_LIST data, FriendlyByteBuf buf) {
        }

        @Override
        public HeelByGroupData.REQUEST_GROUP_LIST decode(FriendlyByteBuf buf) {
            return new HeelByGroupData.REQUEST_GROUP_LIST();
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_GROUP_LIST data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                List dogsList = sender.level().getEntitiesOfClass(Dog.class, sender.getBoundingBox().inflate(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.isOwnedBy((LivingEntity)sender));
                ArrayList<DogGroupsManager.DogGroup> groups_response = new ArrayList<DogGroupsManager.DogGroup>();
                for (Dog dog2 : dogsList) {
                    List<DogGroupsManager.DogGroup> groups = dog2.getGroups().getGroupsReadOnly();
                    for (DogGroupsManager.DogGroup group : groups) {
                        if (groups_response.contains(group)) continue;
                        groups_response.add(group);
                    }
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new HeelByGroupData.RESPONSE_GROUP_LIST(groups_response));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

