/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import com.mojang.serialization.DynamicOps;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;

public class ChemiCanineTalent
extends TalentInstance {
    private final ArrayList<MobEffectInstance> storedEffects = new ArrayList();
    private final int SEARCH_RADIUS = 12;
    private int absorbEffectCooldown;
    private int tickTillSearch;
    private int tickTillEffectDecay = 0;

    public ChemiCanineTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.level().isClientSide) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (this.tickTillEffectDecay > 0) {
            --this.tickTillEffectDecay;
            if (this.tickTillEffectDecay <= 0 && !this.storedEffects.isEmpty()) {
                this.storedEffects.remove(0);
            }
        }
        if (this.absorbEffectCooldown > 0) {
            --this.absorbEffectCooldown;
            return;
        }
        if (dog.readyForNonTrivialAction() && !dog.isOrderedToSit() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            LivingEntity target = this.findTargetToAbsorb(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerAbsorbAction(dog, target);
            }
        }
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        if (!compound.contains("DTN_ChemiCanine", 10)) {
            return;
        }
        CompoundTag_1_21_5 tg0 = compound.getCompound("DTN_ChemiCanine");
        this.tickTillEffectDecay = tg0.getInt("tickTillEffectDecay");
        if (!tg0.contains("effects", 9)) {
            return;
        }
        ListTag_1_21_5 effectTags = tg0.getList("effects", 10);
        for (int i = 0; i < effectTags.size(); ++i) {
            try {
                CompoundTag_1_21_5 effectTag = effectTags.getCompound(i);
                MobEffectInstance effectInst = (MobEffectInstance)MobEffectInstance.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)effectTag.wrapped()).getOrThrow();
                if (effectInst == null) continue;
                this.storedEffects.add(effectInst);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        CompoundTag tg0 = new CompoundTag();
        tg0.putInt("tickTillEffectDecay", this.tickTillEffectDecay);
        ListTag effectTags = new ListTag();
        for (MobEffectInstance effect : this.storedEffects) {
            effectTags.add((Object)EntityUtil_1_21_5.tryEncodeEffect(effect));
        }
        tg0.put("effects", (Tag)effectTags);
        compound.put("DTN_ChemiCanine", (Tag)tg0);
    }

    private void triggerAbsorbAction(Dog dog, @Nonnull LivingEntity target) {
        dog.triggerAction(new AbsorbAction(dog, this, target));
    }

    private LivingEntity findTargetToAbsorb(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<LivingEntity> absorbTargets = new ArrayList<LivingEntity>();
        Predicate<LivingEntity> harmfulEffectAndWitness = e -> this.isTargetHaveNegativeEffect(dog, (LivingEntity)e) && dog.getSensing().hasLineOfSight((Entity)e);
        LivingEntity owner = dog.getOwner();
        if (owner == null) {
            return null;
        }
        if (harmfulEffectAndWitness.test(owner)) {
            absorbTargets.add(owner);
        }
        if (!(dogs = dog.level().getEntitiesOfClass(AbstractDog.class, dog.getBoundingBox().inflate(12.0, 4.0, 12.0), d -> d.getOwner() == owner && harmfulEffectAndWitness.test((LivingEntity)d))).isEmpty()) {
            absorbTargets.addAll(dogs);
        }
        if (!(wolves = dog.level().getEntitiesOfClass(Wolf.class, dog.getBoundingBox().inflate(12.0, 4.0, 12.0), w -> w.getOwner() == owner && harmfulEffectAndWitness.test((LivingEntity)w))).isEmpty()) {
            absorbTargets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.level().getEntitiesOfClass(Player.class, dog.getBoundingBox().inflate(12.0, 4.0, 12.0), p -> p.isAlliedTo((Entity)owner) && harmfulEffectAndWitness.test((LivingEntity)p))).isEmpty()) {
            absorbTargets.addAll(teamPlayers);
        }
        return this.selectAbsorbTarget(dog, absorbTargets);
    }

    private boolean isTargetHaveNegativeEffect(AbstractDog dog, LivingEntity e) {
        for (MobEffectInstance effectInst : e.getActiveEffects()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            return true;
        }
        return false;
    }

    private boolean isHarmfulEffect(MobEffectInstance effectInst) {
        return ((MobEffect)effectInst.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL;
    }

    private LivingEntity selectAbsorbTarget(AbstractDog dog, ArrayList<LivingEntity> absorbTargets) {
        if (absorbTargets.isEmpty()) {
            return null;
        }
        LivingEntity target = absorbTargets.get(0);
        double mindistanceSqr = target.distanceToSqr((Entity)dog);
        LivingEntity owner = dog.getOwner();
        for (LivingEntity i : absorbTargets) {
            if (owner == i) {
                return i;
            }
            double d = i.distanceToSqr((Entity)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int absorbCost(AbstractDog dog, LivingEntity target) {
        int cost = this.level() >= 5 ? 10 : 20;
        return cost;
    }

    public int getMaxAbsorbSize() {
        return this.level() * 2;
    }

    private boolean canAffordToAbsorbTarget(AbstractDog dog, LivingEntity e) {
        return dog.getDogHunger() - 10.0f >= (float)this.absorbCost(dog, e) && this.storedEffects.size() < this.getMaxAbsorbSize();
    }

    private boolean stillValidTarget(Dog dog, LivingEntity target) {
        Dog d;
        if (!target.isAlive()) {
            return false;
        }
        if (!this.isTargetHaveNegativeEffect(dog, target)) {
            return false;
        }
        if (!this.canAffordToAbsorbTarget(dog, target)) {
            return false;
        }
        if (dog.distanceToSqr((Entity)target) > 400.0) {
            return false;
        }
        return !(target instanceof Dog) || !(d = (Dog)target).isDefeated();
    }

    private boolean canAbsorbTarget(AbstractDog dog, LivingEntity e) {
        return dog.distanceToSqr((Entity)e) <= 5.0 && dog.getSensing().hasLineOfSight((Entity)e);
    }

    private void absorb(AbstractDog dog, LivingEntity e) {
        if (this.absorbEffectCooldown > 0) {
            return;
        }
        Holder removeEffect = null;
        for (MobEffectInstance effectInst : e.getActiveEffects()) {
            if (!this.isHarmfulEffect(effectInst)) continue;
            removeEffect = effectInst.getEffect();
            break;
        }
        if (removeEffect == null) {
            return;
        }
        MobEffectInstance effectInst = e.getEffect(removeEffect);
        if (effectInst == null) {
            return;
        }
        if (this.storedEffects.size() >= this.getMaxAbsorbSize()) {
            return;
        }
        if (!e.removeEffect(removeEffect)) {
            return;
        }
        this.storedEffects.add(effectInst);
        dog.setDogHunger(dog.getDogHunger() - (float)this.absorbCost(dog, e));
        if (dog.level() instanceof ServerLevel) {
            ((ServerLevel)dog.level()).sendParticles((ParticleOptions)ParticleTypes.WITCH, e.getX(), e.getY(), e.getZ(), 30, (double)e.getBbWidth(), (double)0.8f, (double)e.getBbWidth(), 0.1);
        }
        this.absorbEffectCooldown = dog.getRandom().nextInt(3) * 20;
        this.tickTillEffectDecay = 24000;
    }

    @Override
    public DogInteractionResult isPotionApplicable(AbstractDog dogIn, MobEffectInstance effectIn) {
        if (this.level() >= 5 && ((MobEffect)effectIn.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
            return DogInteractionResult.FAIL;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
        LivingEntity e;
        if (!target.isAlive()) {
            return;
        }
        if (this.storedEffects.isEmpty()) {
            return;
        }
        MobEffectInstance effectAdding = this.storedEffects.get(0);
        if (target instanceof LivingEntity && !(e = (LivingEntity)target).hasEffect(effectAdding.getEffect())) {
            e.addEffect(effectAdding);
            this.storedEffects.remove(effectAdding);
        }
    }

    public static class AbsorbAction
    extends TriggerableAction {
        private ChemiCanineTalent talentInst;
        @Nonnull
        private LivingEntity target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public AbsorbAction(Dog dog, ChemiCanineTalent talentInst, @Nonnull LivingEntity target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public boolean shouldStopAndFollowOwner() {
            return true;
        }

        @Override
        public float getDistanceForFollowOwner() {
            return 20.0f;
        }

        @Override
        public void tick() {
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.distanceToSqr((Entity)this.target) > 4.0) {
                this.dog.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.dog.getMaxHeadXRot());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.isLeashed() && !this.dog.isPassenger()) {
                        this.dog.getNavigation().moveTo((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else if (this.talentInst.canAbsorbTarget(this.dog, this.target)) {
                this.talentInst.absorb(this.dog, this.target);
            }
        }

        @Override
        public void onStop() {
        }
    }
}

