/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import com.google.common.collect.Maps;
import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyTalents;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogAllyCheck;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogExplosionData;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OokamiKazeTalent
extends TalentInstance {
    private int cooldown = 0;

    public OokamiKazeTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public boolean canExplode() {
        return this.cooldown <= 0;
    }

    public DogCatchGunpowderAndExplodeAction actionCreator(Dog dog, @Nullable DogGunpowderProjectile proj) {
        return new DogCatchGunpowderAndExplodeAction(dog, proj, this.getRadius(), this.getKnockbackModifier());
    }

    public int getRadius() {
        int level = this.level();
        if (level >= 5) {
            return 14;
        }
        if (level <= 1) {
            return 3;
        }
        if (level <= 2) {
            return 4;
        }
        if (level <= 3) {
            return 6;
        }
        if (level <= 4) {
            return 10;
        }
        return 0;
    }

    public float getKnockbackModifier() {
        int level = this.level();
        if (level >= 5) {
            return 2.5f;
        }
        if (level <= 2) {
            return 1.0f;
        }
        if (level <= 3) {
            return 1.4f;
        }
        if (level <= 4) {
            return 1.8f;
        }
        return 1.0f;
    }

    public static void explodeClient(Dog dog) {
        Level level = dog.level();
        Vec3 dog_pos = dog.position();
        if (level.isClientSide) {
            level.playLocalSound(dog_pos.x, dog_pos.y, dog_pos.z, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, dog_pos.x, dog_pos.y, dog_pos.z, 1.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, dog_pos.x, dog_pos.y, dog_pos.z, 1.0, 0.0, 0.0);
    }

    public static class DogCatchGunpowderAndExplodeAction
    extends TriggerableAction {
        private ActionPhase phase;
        private int stopTick;
        private final int radius;
        private final float knockbackModifier;
        private final DogGunpowderProjectile toCatch;
        private int tickTillJump;
        private int tickTillConsumeItem;
        private int tickTillHowl = 50;
        private int tickTillBoom = 55;

        public DogCatchGunpowderAndExplodeAction(Dog dog, @Nullable DogGunpowderProjectile toCatch, int radius, float knockbackModifier) {
            super(dog, false, false);
            this.phase = toCatch != null ? ActionPhase.CATCH : ActionPhase.EXPLODE;
            this.toCatch = toCatch;
            this.radius = radius;
            this.knockbackModifier = knockbackModifier;
        }

        @Override
        public void onStart() {
            if (this.phase == ActionPhase.CATCH) {
                this.beginCatchAnim();
            } else if (this.phase == ActionPhase.EXPLODE) {
                this.beginHowlAnim();
            } else {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.dog.setForcedActionAnim(true);
            this.dog.dogSoundManager.setAmbientLocked(true);
        }

        @Override
        public void tick() {
            if (this.phase == ActionPhase.CATCH) {
                this.updateToCatch();
            } else if (this.phase == ActionPhase.WAIT_TILL_LAND) {
                this.updateWaitTillLand();
            } else {
                this.updateHowlAndExplode();
            }
        }

        private void updateToCatch() {
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.toCatch == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.tickCount >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillJump == 0) {
                this.dog.getJumpControl().jump();
            }
            if (--this.tickTillConsumeItem <= 0 && this.tryConsumeItem()) {
                this.phase = ActionPhase.WAIT_TILL_LAND;
                return;
            }
        }

        public boolean tryConsumeItem() {
            if (this.toCatch == null) {
                return false;
            }
            if (!this.toCatch.isAlive()) {
                return false;
            }
            if (this.dog.distanceToSqr((Entity)this.toCatch) > 4.0) {
                return false;
            }
            this.toCatch.feedDog(this.dog);
            return true;
        }

        public void updateWaitTillLand() {
            if (this.dog.getAnim() == DogAnimation.NONE) {
                this.phase = ActionPhase.EXPLODE;
                this.beginHowlAnim();
                return;
            }
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }

        private void updateHowlAndExplode() {
            if (this.dog.getAnim() != DogAnimation.HOWL) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.tickCount >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            --this.tickTillHowl;
            if (this.tickTillHowl == 0) {
                this.dog.dogSoundManager.playInterruptible(EntityUtil_1_21_5.legacyWolfHowlSound(this.dog), 1.0f, this.dog.getVoicePitch());
            } else if (this.tickTillHowl == 30) {
                this.dog.playSound(EntityUtil_1_21_5.legacyWolfGrowlSound(this.dog), 0.3f, this.dog.getVoicePitch());
            }
            --this.tickTillBoom;
            if (this.tickTillBoom == 0) {
                DogExplosion explode = new DogExplosion(this.dog, this.radius, this.knockbackModifier);
                explode.explode();
                this.setTalentCooldown();
                this.triggerAdvancement();
            }
        }

        @Override
        public void onStop() {
            this.dog.setForcedActionAnim(false);
            this.dog.dogSoundManager.setAmbientLocked(false);
            this.dog.dogSoundManager.interuptPlaying();
            if (this.phase == ActionPhase.EXPLODE) {
                if (this.dog.getAnim() == DogAnimation.HOWL) {
                    this.dog.setAnim(DogAnimation.NONE);
                }
                return;
            }
            if (this.dog.getAnim() == DogAnimation.BACKFLIP) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }

        private void beginCatchAnim() {
            this.stopTick = this.dog.tickCount + DogAnimation.BACKFLIP.getLengthTicks();
            this.dog.setAnim(DogAnimation.BACKFLIP);
            this.tickTillJump = 3;
            this.tickTillConsumeItem = 5;
        }

        private void beginHowlAnim() {
            this.stopTick = this.dog.tickCount + DogAnimation.HOWL.getLengthTicks();
            this.dog.setAnim(DogAnimation.HOWL);
            this.tickTillBoom = 63;
        }

        private void setTalentCooldown() {
            OokamiKazeTalent talent = this.dog.getTalent(DoggyTalents.OOKAMIKAZE).map(inst -> inst.cast(OokamiKazeTalent.class)).orElse(null);
            if (talent == null) {
                return;
            }
            talent.cooldown = 200;
        }

        private void triggerAdvancement() {
            LivingEntity owner = this.dog.getOwner();
            if (!(owner instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)owner;
            DoggyAdvancementTriggers.OOKAMIKAZE_TRIGGER.trigger(this.dog, player);
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }

        private static enum ActionPhase {
            CATCH,
            WAIT_TILL_LAND,
            EXPLODE;

        }
    }

    public static class DogExplosion {
        private final Dog dog;
        private final int radius;
        private float knockbackModifier = 1.0f;
        private final Map<ServerPlayer, Vec3> toSendKnockback = Maps.newHashMap();

        public DogExplosion(Dog dog, int radius, float knockbackModifier) {
            this.dog = dog;
            this.radius = radius;
            this.knockbackModifier = knockbackModifier;
        }

        public void explode() {
            if (this.dog.level().isClientSide) {
                return;
            }
            this.dog.level().gameEvent((Entity)this.dog, (Holder)GameEvent.EXPLODE, this.dog.position());
            this.hurtEntities();
            this.broadcastExploisionToClient();
            this.toSendKnockback.clear();
        }

        private void broadcastExploisionToClient() {
            Level level = this.dog.level();
            MinecraftServer server = level.getServer();
            if (server == null) {
                return;
            }
            PlayerList playerList = server.getPlayerList();
            if (playerList == null) {
                return;
            }
            int notify_radius = 64;
            for (ServerPlayer player : playerList.getPlayers()) {
                double dist_sqr;
                if (player.level() != level || (dist_sqr = player.distanceToSqr((Entity)this.dog)) > 4096.0) continue;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogExplosionData(this.dog.getId(), this.toSendKnockback.get(player)));
            }
        }

        private void hurtEntities() {
            LivingEntity owner = this.dog.getOwner();
            if (owner == null) {
                return;
            }
            Vec3 dog_pos = this.dog.position();
            float ext_radius = 2 * this.radius;
            AABB impact_bb = new AABB(dog_pos.subtract((double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f)), dog_pos.add((double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f), (double)(ext_radius + 1.0f)));
            List entities = this.dog.level().getEntities((Entity)this.dog, impact_bb);
            if (entities.isEmpty()) {
                return;
            }
            for (Entity e : entities) {
                LivingEntity living;
                if (e == this.dog) continue;
                if (e instanceof LivingEntity && DogAllyCheck.isAlliedToDog(this.dog, (Entity)(living = (LivingEntity)e), owner)) {
                    this.lightlyKnockback(owner, e, ext_radius);
                    continue;
                }
                this.hurtAndKnockback(owner, e, ext_radius);
            }
        }

        private double calculateImpactValue(Vec3 dog_pos, Entity e, int hurt_radius) {
            double far_percent = Math.sqrt(e.distanceToSqr(dog_pos)) / (double)hurt_radius;
            if (far_percent > 1.0) {
                return -1.0;
            }
            double close_percent = 1.0 - far_percent;
            float seen_percent = ServerExplosion.getSeenPercent((Vec3)dog_pos, (Entity)e);
            double impact_value = (double)seen_percent * close_percent;
            return impact_value;
        }

        private void lightlyKnockback(LivingEntity owner, Entity e, float hurt_radius) {
            Vec3 dog_pos = this.dog.position();
            double impact_value = this.calculateImpactValue(dog_pos, e, this.radius);
            if (impact_value <= 0.0) {
                return;
            }
            impact_value = Mth.clamp((double)impact_value, (double)0.0, (double)1.0);
            double max_pushback = 0.8;
            this.knockbackEntity(dog_pos, e, 0.8 * impact_value);
        }

        private void knockbackEntity(Vec3 dog_pos, Entity e, double knockback_value) {
            ServerPlayer player;
            LivingEntity living;
            if (e instanceof LivingEntity && (knockback_value *= 1.0 - (living = (LivingEntity)e).getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE)) < 0.0) {
                knockback_value = 0.0;
            }
            Vec3 e_pos = e instanceof PrimedTnt ? e.position() : e.getEyePosition();
            Vec3 knock_vec = e_pos.subtract(dog_pos).normalize().scale(knockback_value);
            Vec3 knock_movement = e.getDeltaMovement().add(knock_vec);
            e.setDeltaMovement(knock_movement);
            if (e instanceof ServerPlayer && this.canKnockbackPlayer(player = (ServerPlayer)e)) {
                this.toSendKnockback.put(player, knock_vec);
            }
        }

        private boolean canKnockbackPlayer(ServerPlayer player) {
            if (player.isSpectator()) {
                return false;
            }
            if (!player.isCreative()) {
                return true;
            }
            return !player.getAbilities().flying;
        }

        private void hurtAndKnockback(LivingEntity owner, Entity e, float hurt_radius) {
            Vec3 dog_pos = this.dog.position();
            double impact_value = this.calculateImpactValue(dog_pos, e, this.radius);
            if (impact_value <= 0.0) {
                return;
            }
            double t = impact_value * impact_value + impact_value;
            int base_damage = 7;
            double hurt_amount = 1.0 + t * 7.0 * (double)this.radius;
            e.hurt(e.damageSources().explosion((Entity)this.dog, (Entity)owner), (float)hurt_amount);
            this.knockbackEntity(dog_pos, e, (double)this.knockbackModifier * impact_value);
        }
    }
}

