/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ShockAbsorberTalent
extends TalentInstance {
    public ShockAbsorberTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        AttributeInstance attrib = dogIn.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (attrib == null) {
            return;
        }
        attrib.setBaseValue(this.getKnockbackResist());
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        AttributeInstance attrib = dogIn.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (attrib == null) {
            return;
        }
        attrib.setBaseValue(this.getKnockbackResist());
    }

    @Override
    public void remove(AbstractDog dogIn) {
        AttributeInstance attrib = dogIn.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
        if (attrib == null) {
            return;
        }
        attrib.setBaseValue(0.25);
    }

    @Override
    public DogInteractionResult negateExplosion(AbstractDog dog) {
        if (this.level() >= this.talent.getMaxLevel()) {
            return DogInteractionResult.SUCCESS;
        }
        return DogInteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dog, DamageSource source, float damage) {
        if (this.isExplosionSource(source)) {
            return InteractionResultHolder.success(Float.valueOf(damage * this.getExplosionResist()));
        }
        return InteractionResultHolder.pass(Float.valueOf(damage));
    }

    private boolean isExplosionSource(DamageSource source) {
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            return true;
        }
        return source.is(DamageTypes.SONIC_BOOM);
    }

    public double getKnockbackResist() {
        int level = this.level();
        if (level >= 5) {
            return 1.0;
        }
        switch (level) {
            case 0: {
                return 0.25;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.6;
            }
            case 3: {
                return 0.75;
            }
            case 4: {
                return 0.9;
            }
        }
        return 0.25;
    }

    public float getExplosionResist() {
        int level = this.level();
        if (level >= 5) {
            return 1.0f;
        }
        if (level < 0) {
            return 0.0f;
        }
        return 0.2f * (float)level;
    }
}

