/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public class DogDistantTeleportToOwnerCrossDimensionPromise
extends AbstractPromise {
    private static final int TIMEOUT = 200;
    private static final int SEARCH_INTERVAL = 10;
    private final BlockPos targetPos;
    private final BlockPos dogPos;
    private final UUID dogUUID;
    private final ServerLevel ownerLevel;
    private final ServerLevel dogLevel;
    private int timeOutTick;
    private int tickTillSearch;
    private Dog teleportedDog;
    private final LivingEntity owner;
    private boolean dogChunkForced;

    public DogDistantTeleportToOwnerCrossDimensionPromise(@Nonnull UUID dogUUID, @Nonnull LivingEntity owner, @Nonnull BlockPos dogPos, ServerLevel dogLevel, ServerLevel ownerLevel) {
        this.dogUUID = dogUUID;
        this.ownerLevel = ownerLevel;
        this.targetPos = owner.blockPosition();
        this.dogPos = dogPos;
        this.owner = owner;
        this.dogLevel = dogLevel;
    }

    @Override
    public void tick() {
        if (this.dogLevel == this.ownerLevel) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Entity e = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            e = this.dogLevel.getEntity(this.dogUUID);
        }
        if (e == null) {
            if (--this.timeOutTick <= 0) {
                this.rejectedMsg = "TIMEOUT";
                this.setState(AbstractPromise.State.REJECTED);
            }
            return;
        }
        if (!(e instanceof Dog)) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Dog dog = (Dog)e;
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool((Level)this.ownerLevel, List.of((Dog)e), this.targetPos, 4, 1);
        if (safePosList.isEmpty()) {
            this.rejectedMsg = "NOSAFEPOS";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        int r = dog.getRandom().nextInt(safePosList.size());
        BlockPos safePos = safePosList.get(r);
        dog.authorizeChangeDimension();
        Entity dogafterTp = dog.changeDimension(DogDistantTeleportToOwnerCrossDimensionPromise.getDogTransition(this.ownerLevel, dog, safePos));
        if (dogafterTp instanceof Dog) {
            this.teleportedDog = (Dog)dogafterTp;
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    @Override
    public void onFulfilled() {
        if (this.teleportedDog == null || !this.teleportedDog.isAlive()) {
            return;
        }
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)"item.doggytalents.conducting_bone.fulfilled.tp_self", (Object[])new Object[]{this.teleportedDog.getName().getString()}));
        }
        this.ownerLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.teleportedDog.getX(), this.teleportedDog.getY(), this.teleportedDog.getZ(), 30, (double)this.teleportedDog.getBbWidth(), (double)0.8f, (double)this.teleportedDog.getBbWidth(), 0.1);
    }

    @Override
    public void onRejected() {
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{Component.literal((String)this.rejectedMsg).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED))}));
        }
    }

    @Override
    public void start() {
        if (this.ownerLevel == null || this.dogLevel == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (this.ownerLevel == this.dogLevel) {
            this.rejectedMsg = "SAMEDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.timeOutTick = 200;
        ChunkPos chunkpos = new ChunkPos(this.dogPos);
        if (this.dogLevel.hasChunk(chunkpos.x, chunkpos.z)) {
            return;
        }
        this.accquireChunk(this.dogLevel, chunkpos);
    }

    private static TeleportTransition getDogTransition(ServerLevel level, Dog dog, BlockPos safePos) {
        return new TeleportTransition(level, Vec3.atBottomCenterOf((Vec3i)safePos), Vec3.ZERO, dog.getYRot(), dog.getXRot(), Set.of(), TeleportTransition.DO_NOTHING);
    }
}

