/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.DoggyRegistries;
import doggytalents.common.util.Util;
import doggytalents.common.variant.CherryWolfVariant;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.MoltenWolfVariant;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.DeferredRegister;

public class DogVariants {
    public static final DeferredRegister<DogVariant> DOG_VARIANT = DeferredRegister.create((ResourceLocation)DoggyRegistries.Keys.DOG_VARIANT, (String)"doggytalents");
    public static final DeferredRegister<DogVariant> DOG_VARIANT_VANILLA = DeferredRegister.create((ResourceLocation)DoggyRegistries.Keys.DOG_VARIANT, (String)"minecraft");
    public static final Supplier<DogVariant> PALE = DogVariants.registerDefault();
    public static final Supplier<DogVariant> CHESTNUT = DogVariants.registerVanilla("chestnut", -6650749);
    public static final Supplier<DogVariant> STRIPED = DogVariants.registerVanilla("striped", -3559552);
    public static final Supplier<DogVariant> WOOD = DogVariants.registerVanilla("woods", -9021380);
    public static final Supplier<DogVariant> RUSTY = DogVariants.registerVanilla("rusty", -2194632);
    public static final Supplier<DogVariant> BLACK = DogVariants.registerVanilla("black", -14080471);
    public static final Supplier<DogVariant> SNOWY = DogVariants.registerVanilla("snowy", -4683906);
    public static final Supplier<DogVariant> ASHEN = DogVariants.registerVanilla("ashen", -7173743);
    public static final Supplier<DogVariant> SPOTTED = DogVariants.registerVanilla("spotted", -3621840);
    public static final Supplier<DogVariant> CHERRY = DogVariants.register("cherry", CherryWolfVariant::new);
    public static final Supplier<DogVariant> LEMONY_LIME = DogVariants.register("lemony_lime", -5715838);
    public static final Supplier<DogVariant> HIMALAYAN_SALT = DogVariants.register("himalayan_salt", -4891549);
    public static final Supplier<DogVariant> BAMBOO = DogVariants.register("bamboo", -10317534);
    public static final Supplier<DogVariant> CRIMSON = DogVariants.register("crimson", (DogVariant.Props p) -> p.guiColor(-8245453).glowingOverlay(Util.getResource("textures/entity/dog/classical/compl/overlay/wolf_crimson_overlay.png")));
    public static final Supplier<DogVariant> WARPED = DogVariants.register("warped", (DogVariant.Props p) -> p.guiColor(-14459811).glowingOverlay(Util.getResource("textures/entity/dog/classical/compl/overlay/wolf_warped_overlay.png")));
    public static final Supplier<DogVariant> BIRCH = DogVariants.register("birch", -3227246);
    public static final Supplier<DogVariant> PISTACHIO = DogVariants.register("pistachio", -6053285);
    public static final Supplier<DogVariant> GUACAMOLE = DogVariants.register("guacamole", -6639325);
    public static final Supplier<DogVariant> VSCODE = DogVariants.register("vscode", -16746284);
    public static final Supplier<DogVariant> MOLTEN = DogVariants.register("molten", MoltenWolfVariant::new);
    public static final Supplier<DogVariant> YUZU = DogVariants.register("yuzu", -1854463);
    public static final Supplier<DogVariant> MISSING = DogVariants.registerMissing();

    private static Supplier<DogVariant> register(String name, Function<String, DogVariant> variant_creator) {
        DogVariant captured_variant = variant_creator.apply(name);
        return DOG_VARIANT.register(name, () -> captured_variant);
    }

    private static Supplier<DogVariant> register(String name, int color) {
        return DogVariants.register(name, (DogVariant.Props p) -> p.guiColor(color));
    }

    private static Supplier<DogVariant> register(String name, Consumer<DogVariant.Props> props_consumer) {
        DogVariant.Props props = DogVariant.props(name);
        props.icon(Util.getResource("textures/item/doggy_charm.png"));
        props_consumer.accept(props);
        DogVariant captured_variant = new DogVariant(props);
        return DOG_VARIANT.register(name, () -> captured_variant);
    }

    private static Supplier<DogVariant> registerVanilla(String name, int color) {
        DogVariant.Props props = DogVariant.propsVanilla(name);
        props.icon(Util.getResource("textures/entity/dog/classical_icon/" + name + ".png"));
        props.guiColor(color);
        DogVariant captured_variant = new DogVariant(props);
        return DOG_VARIANT_VANILLA.register(name, () -> captured_variant);
    }

    private static Supplier<DogVariant> registerDefault() {
        return DOG_VARIANT_VANILLA.register("pale", () -> DogVariant.PALE);
    }

    private static Supplier<DogVariant> registerMissing() {
        return DOG_VARIANT.register("missing", () -> DogVariant.MISSING);
    }
}

