/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import com.mojang.brigadier.CommandDispatcher;
import doggytalents.DogVariants;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyAdvancementTriggers;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyBrewingRecipes;
import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItemGroups;
import doggytalents.DoggyItems;
import doggytalents.DoggyRecipeSerializers;
import doggytalents.DoggyRegistries;
import doggytalents.DoggySerializers;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.TalentsOptions;
import doggytalents.api.feature.FoodHandler;
import doggytalents.client.ClientSetup;
import doggytalents.client.DTNClientDogSleepOnManager;
import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.DoggyKeybinds;
import doggytalents.client.PettingArmPose;
import doggytalents.client.data.DTBlockstateProvider;
import doggytalents.client.data.DTItemModelProvider;
import doggytalents.client.entity.render.world.BedFinderRenderer;
import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.command.DoggyCommands;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.data.DTAdvancementProvider;
import doggytalents.common.data.DTBlockTagsProvider;
import doggytalents.common.data.DTEntityTagsProvider;
import doggytalents.common.data.DTItemTagsProvider;
import doggytalents.common.data.DTLootModifierProvider;
import doggytalents.common.data.DTLootTableProvider;
import doggytalents.common.data.DTNDatapackProvider;
import doggytalents.common.data.DTNPackMetadataProvider;
import doggytalents.common.data.DTRecipeProvider;
import doggytalents.common.entity.BoostingFoodHandler;
import doggytalents.common.entity.DogDrinkMilkHandler;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.entity.WhitelistFoodHandler;
import doggytalents.common.entity.texture.DogAllowedSkinManager;
import doggytalents.common.event.EventHandler;
import doggytalents.common.event.PackHandler;
import doggytalents.common.item.itemgroup.DTNCompostables;
import doggytalents.common.item.itemgroup.DTNItemCategory;
import doggytalents.common.lib.Constants;
import doggytalents.common.network.PacketHandler;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="doggytalents")
public class DoggyTalentsNext {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents");
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Constants.CHANNEL_NAME).clientAcceptedVersions(Constants.PROTOCOL_VERSION::equals).serverAcceptedVersions(Constants.PROTOCOL_VERSION::equals).networkProtocolVersion(Constants.PROTOCOL_VERSION::toString).simpleChannel();

    public DoggyTalentsNext() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interModProcess);
        DogVariants.DOG_VARIANT.register(modEventBus);
        DogVariants.DOG_VARIANT_VANILLA.register(modEventBus);
        DoggyBlocks.BLOCKS.register(modEventBus);
        DoggyTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        DoggyItems.ITEMS.register(modEventBus);
        DoggyEntityTypes.ENTITIES.register(modEventBus);
        DoggyContainerTypes.CONTAINERS.register(modEventBus);
        DoggySerializers.SERIALIZERS.register(modEventBus);
        TalentsOptions.TALENT_OPTIONS.register(modEventBus);
        DoggySounds.SOUNDS.register(modEventBus);
        DoggyRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        DoggyTalents.TALENTS.register(modEventBus);
        DoggyAccessories.ACCESSORIES.register(modEventBus);
        DoggyAccessoryTypes.ACCESSORY_TYPES.register(modEventBus);
        DoggyAttributes.ATTRIBUTES.register(modEventBus);
        DoggyItemGroups.ITEM_GROUP.register(modEventBus);
        DoggyEffects.EFFECTS.register(modEventBus);
        DTLootModifierProvider.CODEC.register(modEventBus);
        modEventBus.addListener(DoggyRegistries::newRegistry);
        modEventBus.addListener(DoggyEntityTypes::addEntityAttributes);
        modEventBus.addListener(PackHandler::onAddPackFinder);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::serverStarting);
        forgeEventBus.addListener(this::registerCommands);
        forgeEventBus.addListener(DogAllowedSkinManager::onRegisterReloadListener);
        forgeEventBus.addListener(DogAllowedSkinManager::onDataPackSyncServer);
        forgeEventBus.register((Object)new EventHandler());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(DoggyKeybinds::registerDTKeyMapping);
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(DoggyBlocks::registerBlockColours);
            modEventBus.addListener(DoggyItems::registerItemColours);
            modEventBus.addListener(ClientEventHandler::registerModelForBaking);
            modEventBus.addListener(ClientEventHandler::modifyBakedModels);
            modEventBus.addListener(ClientSetup::setupTileEntityRenderers);
            modEventBus.addListener(ClientSetup::setupEntityRenderers);
            modEventBus.addListener(ClientSetup::addClientReloadListeners);
            modEventBus.addListener(ClientSetup::registerOverlay);
            forgeEventBus.register((Object)new ClientEventHandler());
            forgeEventBus.addListener(BedFinderRenderer::onWorldRenderLast);
            forgeEventBus.addListener(CanineTrackerLocateRenderer::onWorldRenderLast);
            forgeEventBus.addListener(CanineTrackerLocateRenderer::tickUpdate);
            forgeEventBus.register((Object)DTNClientPettingManager.get());
            forgeEventBus.register((Object)DTNClientDogSleepOnManager.get());
        });
        ConfigHandler.init(modEventBus);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        FoodHandler.registerHandler(new MeatFoodHandler());
        FoodHandler.registerHandler(new BoostingFoodHandler());
        FoodHandler.registerHandler(new DogDrinkMilkHandler());
        FoodHandler.registerHandler(new WhitelistFoodHandler());
        event.enqueueWork(() -> {
            DoggyAdvancementTriggers.registerAll();
            DoggyBrewingRecipes.registerAll();
            ConfigHandler.initTalentConfig();
            RiceMillBlockEntity.initGrindMap();
            DTNItemCategory.init();
            DTNCompostables.init();
        });
    }

    public void serverStarting(ServerStartingEvent event) {
    }

    public void registerCommands(RegisterCommandsEvent event) {
        DoggyCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientSetup.onClientSetup(event);
        ClientSetup.setupScreenManagers(event);
        PettingArmPose.init();
    }

    protected void interModProcess(InterModProcessEvent event) {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        DTNPackMetadataProvider.start(event);
        if (event.includeClient()) {
            DTBlockstateProvider blockstates = new DTBlockstateProvider(packOutput, event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockstates);
            gen.addProvider(true, (DataProvider)new DTItemModelProvider(packOutput, blockstates.getExistingHelper()));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new DTAdvancementProvider(packOutput, lookup, event.getExistingFileHelper()));
            DTBlockTagsProvider blockTagProvider = new DTBlockTagsProvider(packOutput, lookup, event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockTagProvider);
            gen.addProvider(true, (DataProvider)new DTItemTagsProvider(packOutput, lookup, blockTagProvider.m_274426_(), event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new DTRecipeProvider(packOutput));
            gen.addProvider(true, (DataProvider)new DTLootTableProvider(packOutput));
            gen.addProvider(true, (DataProvider)new DTLootModifierProvider(packOutput));
            gen.addProvider(true, (DataProvider)new DTEntityTagsProvider(packOutput, lookup, event.getExistingFileHelper()));
        }
        DTNDatapackProvider.start(event);
    }
}

