/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class RenderUtil {
    public static <T extends Entity> void renderLabelWithScale(T entity, EntityRenderer<T> renderer, EntityRenderDispatcher entityRenderDispatcher, Component text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yChange, boolean renderBkg) {
        RenderUtil.renderLabelWithScale(!entity.m_20163_(), renderer, entityRenderDispatcher, text, stack, buffer, packedLightIn, scale, yChange + entity.m_20206_() + 0.5f, renderBkg);
    }

    public static <T extends Entity> void renderLabelWithScale(T entity, EntityRenderer<T> renderer, EntityRenderDispatcher entityRenderDispatcher, String text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yChange, boolean renderBkg) {
        RenderUtil.renderLabelWithScale(!entity.m_20163_(), renderer, entityRenderDispatcher, (Component)Component.m_237113_((String)text), stack, buffer, packedLightIn, scale, yChange + entity.m_20206_() + 0.5f, renderBkg);
    }

    public static void renderLabelWithScale(boolean flag, EntityRenderer renderer, EntityRenderDispatcher entityRenderDispatcher, Component text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yOffset, boolean renderBkg) {
        stack.m_85836_();
        stack.m_85837_(0.0, (double)yOffset, 0.0);
        stack.m_252781_(entityRenderDispatcher.m_253208_());
        stack.m_85841_(-scale, -scale, scale);
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float f1 = renderBkg ? Minecraft.m_91087_().f_91066_.m_92141_(0.25f) : 0.0f;
        int j = (int)(f1 * 255.0f) << 24;
        Font fontrenderer = renderer.m_114481_();
        float f2 = (float)(-fontrenderer.m_92852_((FormattedText)text)) / 2.0f;
        fontrenderer.m_272077_(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLightIn);
        if (flag) {
            fontrenderer.m_272077_(text, f2, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLightIn);
        }
        stack.m_85849_();
    }

    public static void blit(int x, int y, int zLevel, int width, int height, TextureAtlasSprite sprite) {
        RenderUtil.innerBlit(x, x + width, y, y + height, zLevel, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_());
    }

    public static void blit(int x, int y, int width, int height, int textureX, int textureY) {
        RenderUtil.blit(x, y, 0, width, height, textureX, textureY, 256, 256);
    }

    public static void blit(int p_blit_0_, int p_blit_1_, int p_blit_2_, float p_blit_3_, float p_blit_4_, int p_blit_5_, int p_blit_6_, int p_blit_7_, int p_blit_8_) {
        RenderUtil.innerBlit(p_blit_0_, p_blit_0_ + p_blit_5_, p_blit_1_, p_blit_1_ + p_blit_6_, p_blit_2_, p_blit_5_, p_blit_6_, p_blit_3_, p_blit_4_, p_blit_8_, p_blit_7_);
    }

    public static void blit(int p_blit_0_, int p_blit_1_, int p_blit_2_, int p_blit_3_, float p_blit_4_, float p_blit_5_, int p_blit_6_, int p_blit_7_, int p_blit_8_, int p_blit_9_) {
        RenderUtil.innerBlit(p_blit_0_, p_blit_0_ + p_blit_2_, p_blit_1_, p_blit_1_ + p_blit_3_, 0, p_blit_6_, p_blit_7_, p_blit_4_, p_blit_5_, p_blit_8_, p_blit_9_);
    }

    public static void blit(int p_blit_0_, int p_blit_1_, float p_blit_2_, float p_blit_3_, int p_blit_4_, int p_blit_5_, int p_blit_6_, int p_blit_7_) {
        RenderUtil.blit(p_blit_0_, p_blit_1_, p_blit_4_, p_blit_5_, p_blit_2_, p_blit_3_, p_blit_4_, p_blit_5_, p_blit_6_, p_blit_7_);
    }

    public static void innerBlit(int minX, int maxX, int yMin, int yMax, int zLevel, int textureXMin, int textureXMax, float textureYMin, float textureYMax, int textureXScale, int textureYScale) {
        RenderUtil.innerBlit(minX, maxX, yMin, yMax, zLevel, textureYMin / (float)textureXScale, (textureYMin + (float)textureXMin) / (float)textureXScale, textureYMax / (float)textureYScale, (textureYMax + (float)textureXMax) / (float)textureYScale);
    }

    public static void innerBlit(int minX, int maxX, int yMin, int yMax, int zLevel, float textureXMin, float textureXMax, float textureYMin, float textureYMax) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_((double)minX, (double)yMax, (double)zLevel).m_7421_(textureXMin, textureYMax).m_5752_();
        bufferbuilder.m_5483_((double)maxX, (double)yMax, (double)zLevel).m_7421_(textureXMax, textureYMax).m_5752_();
        bufferbuilder.m_5483_((double)maxX, (double)yMin, (double)zLevel).m_7421_(textureXMax, textureYMin).m_5752_();
        bufferbuilder.m_5483_((double)minX, (double)yMin, (double)zLevel).m_7421_(textureXMin, textureYMin).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static int rgbToInt(int[] rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int[] intToRgb(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        return new int[]{r, g, b};
    }
}

