/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.DoggyTalents;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogArmorModel;
import doggytalents.client.entity.model.SyncedRenderFunctionWithHeadModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.DoggyArmorMapping;
import doggytalents.client.entity.render.layer.DogArmorHelmetAltModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;

public class DoggyArmorRenderer
extends RenderLayer<Dog, DogModel> {
    private DogArmorModel model;
    private DogArmorModel newModel;
    private DogArmorModel legacyModel;
    private SyncedRenderFunctionWithHeadModel alternativeModel;
    private boolean initAltModel = false;
    private DogArmorHelmetAltModel helmetAltModel;
    private final TextureAtlas dogArmorTrimAtlas;

    public DoggyArmorRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.newModel = new DogArmorModel(ctx.m_174023_(ClientSetup.DOG_ARMOR));
        this.legacyModel = new DogArmorModel(ctx.m_174023_(ClientSetup.DOG_ARMOR_LEGACY));
        this.alternativeModel = new SyncedRenderFunctionWithHeadModel(ctx.m_174023_(ClientSetup.DOG_SYNCED_FUNCTION_WITH_HEAD));
        this.model = this.newModel;
        this.helmetAltModel = new DogArmorHelmetAltModel(ctx);
        this.dogArmorTrimAtlas = ctx.m_266367_().m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.m_21824_() || dog.m_20145_()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional inst = dog.getTalent((Supplier)DoggyTalents.DOGGY_ARMOR);
        if (!inst.isPresent()) {
            return;
        }
        this.model = (Boolean)ConfigHandler.CLIENT.USE_LEGACY_DOG_ARMOR_RENDER.get() != false ? this.legacyModel : this.newModel;
        DogModel parentModel = (DogModel)this.m_117386_();
        parentModel.m_102624_(this.model);
        this.model.sync(parentModel);
        this.initAltModel = false;
        this.checkAndRenderSlot(dog, EquipmentSlot.HEAD, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.CHEST, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.LEGS, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, EquipmentSlot.FEET, poseStack, buffer, packedLight);
    }

    private void checkAndRenderSlot(Dog dog, EquipmentSlot slot, PoseStack stack, MultiBufferSource buffer, int light) {
        ItemStack itemStack = dog.m_6844_(slot);
        Item item = itemStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armor = (ArmorItem)item;
        switch (slot) {
            case HEAD: {
                this.model.setHelmet();
                break;
            }
            case CHEST: {
                this.model.setChestplate();
                break;
            }
            case LEGS: {
                this.model.setLeggings();
                break;
            }
            case FEET: {
                this.model.setBoot();
                break;
            }
            default: {
                return;
            }
        }
        Optional<Model> altModel = this.getAlternativeArmorModel(dog, slot, stack, itemStack);
        if (altModel.isPresent()) {
            if (!this.initAltModel) {
                this.initAltModel = true;
                DogModel parentModel = (DogModel)this.m_117386_();
                parentModel.m_102624_(this.alternativeModel);
                this.alternativeModel.sync(parentModel);
            }
            this.startRenderAlternativeModelFromRoot(altModel.get(), dog, stack, buffer, light, itemStack, armor);
            return;
        }
        this.renderArmorCutout(this.model, DoggyArmorMapping.getMappedResource(itemStack.m_41720_(), dog, itemStack), stack, buffer, light, dog, 1.0f, 1.0f, 1.0f);
        Optional trim = ArmorTrim.m_266285_((RegistryAccess)dog.m_9236_().m_9598_(), (ItemStack)itemStack);
        if (trim.isPresent()) {
            this.renderTrim(armor.m_40401_(), stack, buffer, light, (ArmorTrim)trim.get(), (Model)this.model);
        }
        if (itemStack.m_41790_()) {
            this.renderGlint(stack, buffer, light, (Model)this.model);
        }
    }

    private Optional<Model> getAlternativeArmorModel(Dog dog, EquipmentSlot slot, PoseStack stack, ItemStack itemStack) {
        HumanoidArmorModel<?> dummy;
        Model customHeadModel;
        if (slot == EquipmentSlot.HEAD && ((Boolean)ConfigHandler.CLIENT.USE_THIRD_PARTY_PLAYER_HELMET_MODEL.get()).booleanValue() && (customHeadModel = ForgeHooksClient.getArmorModel((LivingEntity)dog, (ItemStack)itemStack, (EquipmentSlot)slot, dummy = this.helmetAltModel.getDummy())) != dummy && customHeadModel != null) {
            return Optional.of(customHeadModel);
        }
        if (slot == EquipmentSlot.HEAD && ((Boolean)ConfigHandler.CLIENT.USE_PLAYER_HELMET_MODEL_BY_DEFAULT.get()).booleanValue()) {
            return Optional.of(this.helmetAltModel.getModel());
        }
        return Optional.empty();
    }

    private void startRenderAlternativeModelFromRoot(Model model, Dog dog, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack, ArmorItem armor) {
        this.alternativeModel.startRenderFromRoot(stack, stack1 -> {
            stack1.m_85836_();
            stack1.m_85841_(0.6f, 0.6f, 0.6f);
            stack1.m_85837_(0.0, (double)0.15f, 0.07);
            this.renderAlternativeModel(model, dog, stack1, buffer, light, itemStack);
            Optional trim = ArmorTrim.m_266285_((RegistryAccess)dog.m_9236_().m_9598_(), (ItemStack)itemStack);
            if (trim.isPresent()) {
                this.renderTrim(armor.m_40401_(), stack, buffer, light, (ArmorTrim)trim.get(), model);
            }
            if (itemStack.m_41790_()) {
                this.renderGlint(stack, buffer, light, model);
            }
            stack1.m_85849_();
        });
    }

    private void renderAlternativeModel(Model model, Dog dog, PoseStack stack, MultiBufferSource buffer, int light, ItemStack itemStack) {
        ResourceLocation texLoc = DoggyArmorMapping.getMappedResource(itemStack.m_41720_(), dog, itemStack);
        VertexConsumer ivertexbuilder = buffer.m_6299_(RenderType.m_110431_((ResourceLocation)texLoc));
        model.m_7695_(stack, ivertexbuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderArmorCutout(DogArmorModel model, ResourceLocation textureLocationIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Dog entityIn, float red, float green, float blue) {
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110431_((ResourceLocation)textureLocationIn));
        model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private void renderTrim(ArmorMaterial material, PoseStack stack, MultiBufferSource buffer, int light, ArmorTrim trim, Model model) {
        TextureAtlasSprite textureatlassprite = this.dogArmorTrimAtlas.m_118316_(trim.m_267606_(material));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(buffer.m_6299_(Sheets.m_266442_()));
        model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack stack, MultiBufferSource buffer, int light, Model model) {
        model.m_7695_(stack, buffer.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

