/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.misc.DogPlushieModel;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class DogPlushieRenderer
extends EntityRenderer<DogPlushie> {
    private DogPlushieModel model;

    public DogPlushieRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new DogPlushieModel(ctx.m_174023_(ClientSetup.DOG_PLUSHIE));
    }

    public ResourceLocation getTextureLocation(DogPlushie plushie) {
        return plushie.getDogVariant().texture();
    }

    private RenderType getRenderType(DogPlushie plushie, boolean overlay) {
        if (overlay) {
            ResourceLocation collar_res = plushie.getCollarThicc() ? Resources.COLLAR_THICC : Resources.COLLAR_DEFAULT;
            return RenderType.m_110473_((ResourceLocation)collar_res);
        }
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(plushie));
    }

    public void render(DogPlushie piano, float p_114486_, float p_114487_, PoseStack stack, MultiBufferSource bufferSource, int light) {
        stack.m_85836_();
        stack.m_85841_(-0.6f, -0.6f, 0.6f);
        stack.m_252880_(0.0f, -1.05f, 0.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14177_((float)piano.m_146908_())));
        VertexConsumer consumer = bufferSource.m_6299_(this.getRenderType(piano, false));
        this.model.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        int color = piano.getCollarColor();
        float[] arr = Util.rgbIntToFloatArray(color);
        consumer = bufferSource.m_6299_(this.getRenderType(piano, true));
        this.model.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, arr[0], arr[1], arr[2], 1.0f);
        stack.m_85849_();
    }
}

