/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ConductingBoneData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class ConductingBoneScreen
extends StringEntrySelectScreen {
    private Font font;
    private final ArrayList<String> dogNameList = new ArrayList();
    private final ArrayList<UUID> dogIdList = new ArrayList();
    private boolean showUuid = false;
    private boolean toBed = false;

    public ConductingBoneScreen() {
        super((Component)Component.m_237115_((String)"doggytalents.screen.conducting_bone"));
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        ConductingBoneScreen screen = new ConductingBoneScreen();
        if (mc.f_91074_ != null && mc.f_91074_.m_6144_()) {
            screen.toBed = true;
        }
        mc.m_91152_((Screen)screen);
        screen.requestDogs();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(0, pY, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        showUuid.m_252865_(mX - 100 - showUuid.m_5711_() - 2);
        FlatButton toBedButton = new FlatButton(0, pY += showUuid.m_93694_() + 2, 60, 20, (Component)Component.m_237113_((String)(this.toBed ? "To Bed" : "To Self")), b -> {
            if (this.toBed) {
                this.toBed = false;
                b.m_93666_((Component)Component.m_237113_((String)"To Self"));
            } else {
                this.toBed = true;
                b.m_93666_((Component)Component.m_237113_((String)"To Bed"));
            }
        });
        toBedButton.m_252865_(mX - 100 - toBedButton.m_5711_() - 2);
        FlatButton help = new FlatButton(0, pY += toBedButton.m_93694_() + 2, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.conducting_bone.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, ConductingBoneScreen.this.font));
                graphics.m_280666_(ConductingBoneScreen.this.font, list, mouseX, mouseY);
            }
        };
        help.m_252865_(mX - 100 - help.m_5711_() - 2);
        pY += help.m_93694_() + 2;
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)toBedButton);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        UUID uuid = this.dogIdList.get(entry_id);
        MutableComponent uuid_c1 = Component.m_237113_((String)uuid.toString()).m_130940_(ChatFormatting.GRAY);
        if (this.f_96544_ >= 273) {
            int mX = this.f_96543_ / 2;
            int mY = this.f_96544_ / 2;
            int uuid_width = this.font.m_92852_((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.m_280430_(this.font, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.m_280666_(this.font, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.m_280488_(this.font, I18n.m_118938_((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestDistantTeleport(this.dogIdList.get(id));
        Minecraft.m_91087_().m_91152_(null);
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDogsData());
    }

    public void assignResponse(List<Pair<UUID, String>> dogLs) {
        this.dogNameList.clear();
        this.dogIdList.clear();
        for (Pair<UUID, String> entry : dogLs) {
            this.dogNameList.add((String)entry.getRight());
            this.dogIdList.add((UUID)entry.getLeft());
        }
        this.updateEntries(this.dogNameList);
    }

    private void requestDistantTeleport(UUID dogUuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDistantTeleportDogData(dogUuid, this.toBed));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }
}

