/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogSize;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.client.screen.PetSelectScreen;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.lib.Resources;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.world.entity.LivingEntity;

public class DogStatusViewBoxElement
extends AbstractElement {
    private Dog dog;
    private Font font;
    private FlatButton petButton;

    public DogStatusViewBoxElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.f_91062_;
    }

    @Override
    public AbstractElement init() {
        this.petButton = new FlatButton(0, 0, 30, 50, (Component)Component.m_237119_(), b -> PetSelectScreen.open()){

            @Override
            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                if (this.f_93622_) {
                    ToolTipOverlayManager.get().setComponents(List.of(Component.m_237110_((String)"doggui.home.pet_hint", (Object[])new Object[]{DogStatusViewBoxElement.this.dog.getGenderPronoun()})));
                }
            }
        };
        this.petButton.m_252865_(this.getRealX() + this.getSizeX() / 2 - this.petButton.m_5711_() / 2);
        this.petButton.m_253211_(this.getRealY() + this.getSizeY() / 2 - this.petButton.m_93694_() / 2 + 10);
        this.addChildren((GuiEventListener)this.petButton);
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawDogLevelKanji(graphics, mouseX, mouseY, partialTicks);
        int e_mX = this.getRealX() + this.getSizeX() / 2;
        int e_mY = this.getRealY() + this.getSizeY() / 2;
        this.renderVariantIcon(graphics, this.dog, this.getRealX() + this.getSizeX() - 16 - 3, this.getRealY() - 4);
        DogStatusViewBoxElement.renderDogInside(graphics, this.dog, e_mX, e_mY + 32, 50, e_mX - mouseX, e_mY - mouseY);
        this.renderHealthBar(graphics, this.dog, e_mX - 41, this.getRealY() + this.getSizeY() - 10);
        int points = this.dog.getSpendablePoints();
        this.renderHungerStatusStr(graphics, this.dog, this.getRealX(), this.getRealY());
    }

    private void drawDogLevelKanji(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 128;
        graphics.m_280398_(DogStatusViewBoxElement.getKanjiDogLevel(this.dog), this.getRealX() + this.getSizeX() / 2 - imgeSize / 2, this.getRealY() + this.getSizeY() / 2 - imgeSize / 2, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        RenderSystem.disableBlend();
    }

    public static ResourceLocation getKanjiDogLevel(Dog dog) {
        DogLevel dogLevel = dog.getDogLevel();
        if (dogLevel.isFullKami()) {
            return Resources.KANJI_KAMI;
        }
        int level_normal = dogLevel.getLevel(DogLevel.Type.NORMAL);
        ResourceLocation ret = Resources.KANJI_NORMAL;
        if (level_normal >= 20) {
            ret = Resources.KANJI_SUPER;
        }
        if (level_normal >= 40) {
            ret = Resources.KANJI_MASTER;
        }
        if (level_normal >= 60) {
            ret = Resources.KANJI_KAMI;
        }
        return ret;
    }

    public static void renderDogInside(GuiGraphics graphics, Dog dog, int dog_mX, int dog_mY, int size, int lookX, int lookY) {
        boolean dogTooBig;
        DogSize currentDogSize = dog.getDogSize();
        boolean bl = dogTooBig = currentDogSize.getId() > DogSize.MODERATO.getId();
        if (dogTooBig) {
            dog.setDogSize(DogSize.MODERATO);
        }
        Component currentDogName = dog.m_7770_();
        String currentDogNameStr = "";
        boolean nameTooLong = false;
        if (currentDogName != null) {
            currentDogNameStr = currentDogName.getString();
            boolean bl2 = nameTooLong = currentDogNameStr.length() > 14;
        }
        if (nameTooLong) {
            String tempName = currentDogNameStr.substring(0, 13) + " ..";
            dog.setDogCustomName((Component)Component.m_237113_((String)tempName));
        }
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)dog_mX, (int)dog_mY, (int)size, (float)lookX, (float)lookY, (LivingEntity)dog);
        if (nameTooLong) {
            dog.setDogCustomName(currentDogName);
        }
        if (dogTooBig) {
            dog.setDogSize(currentDogSize);
        }
    }

    public void renderHealthBar(GuiGraphics graphics, Dog dog, int x, int y) {
        int pX = x;
        int pY = y;
        String healthStrPrefix = " x " + StatFormatter.f_12872_.format(dog.m_21223_());
        MutableComponent health_c0 = null;
        if (dog.hasWolfArmor()) {
            int wolf_armor_ext_hp = dog.wolfArmor().m_41776_() - dog.wolfArmor().m_41773_();
            String healthStrPosfix = "+" + wolf_armor_ext_hp;
            health_c0 = Component.m_237113_((String)healthStrPrefix).m_7220_((Component)Component.m_237113_((String)healthStrPosfix).m_130948_(Style.f_131099_.m_178520_(-3042707)));
        } else {
            String healthStrPosfix = "/" + (int)dog.m_21233_();
            String healthStr = healthStrPrefix + healthStrPosfix;
            health_c0 = Component.m_237113_((String)healthStr);
        }
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX += (80 - (8 + this.font.m_92852_((FormattedText)health_c0))) / 2, pY, 16, 0, 9, 9);
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 0, 9, 9);
        graphics.m_280430_(this.font, (Component)health_c0, pX += 9, ++pY, -1);
    }

    private void renderHungerStatusStr(GuiGraphics graphics, Dog dog, int x, int y) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue()) {
            return;
        }
        graphics.m_280218_(DogScreenOverlays.GUI_ICONS_LOCATION, x, y, 52, 27, 9, 9);
        int hunger = (int)dog.getDogHunger();
        graphics.m_280488_(this.font, "" + hunger, x + 10, y + 1, -1);
    }

    private void renderVariantIcon(GuiGraphics graphics, Dog dog, int x, int y) {
        DogVariant variant = dog.dogVariant();
        ResourceLocation iconLoc = variant.icon().orElse(null);
        if (iconLoc == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = 16;
        graphics.m_280398_(iconLoc, x, y, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        RenderSystem.disableBlend();
    }
}

