/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import doggytalents.DoggyItems;
import doggytalents.common.advancements.triggers.DogBandaidApplyTrigger;
import doggytalents.common.advancements.triggers.DogDrunkTrigger;
import doggytalents.common.advancements.triggers.DogRecoveredTrigger;
import doggytalents.common.advancements.triggers.OokamikazeTrigger;
import doggytalents.common.data.DisplayInfoBuilder;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTAdvancementProvider
extends ForgeAdvancementProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public DTAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new DoggyAdvancementsSubProvider()));
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    private static ItemStack createFullRecoveryBed(boolean special) {
        Block casing = special ? Blocks.f_271326_ : Blocks.f_50010_;
        Block bedding = special ? Blocks.f_50108_ : Blocks.f_50041_;
        return DogBedUtil.createItemStackForced(casing, bedding);
    }

    public static class DoggyAdvancementsSubProvider
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            Advancement charm_advancement = Advancement.Builder.m_138353_().m_138358_(DisplayInfoBuilder.create().icon(DoggyItems.DOGGY_CHARM).frame(FrameType.TASK).translate("doggy_charm_summon").background("adventure.png").build()).m_138386_("summon_dog", (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_285945_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_(), (ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DoggyItems.DOGGY_CHARM.get()}))).m_138389_(consumer, Util.getResourcePath("dtn_core/summon_dog"));
            Advancement train_dog_advancement = Advancement.Builder.m_138353_().m_138398_(charm_advancement).m_138358_(DisplayInfoBuilder.create().icon(DoggyItems.TRAINING_TREAT).frame(FrameType.TASK).translate("train_dog_hajimemashite").build()).m_138386_("train_dog", (CriterionTriggerInstance)PlayerInteractTrigger.TriggerInstance.m_285812_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)DoggyItems.TRAINING_TREAT.get()}), (ContextAwarePredicate)EntityPredicate.m_285787_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_20499_).m_36662_()))).m_138389_(consumer, Util.getResourcePath("dtn_core/train_dog"));
            Advancement sake_advancement = Advancement.Builder.m_138353_().m_138398_(train_dog_advancement).m_138358_(DisplayInfoBuilder.create().icon(DoggyItems.SAKE).frame(FrameType.TASK).translate("get_dog_drunk").build()).m_138386_("get_dog_drunk", (CriterionTriggerInstance)DogDrunkTrigger.getInstance()).m_138389_(consumer, Util.getResourcePath("default/get_dog_drunk"));
            Advancement ookamikaze_advancement = Advancement.Builder.m_138353_().m_138398_(train_dog_advancement).m_138358_(DisplayInfoBuilder.create().icon(() -> Items.f_42403_).frame(FrameType.TASK).translate("ookamikaze_trigger").build()).m_138386_("ookamikaze_trigger", (CriterionTriggerInstance)OokamikazeTrigger.getInstance()).m_138389_(consumer, Util.getResourcePath("default/ookamikaze_trigger"));
            Advancement bandaid_advancement = Advancement.Builder.m_138353_().m_138398_(train_dog_advancement).m_138358_(DisplayInfoBuilder.create().icon(() -> DoggyItems.BANDAID.get()).frame(FrameType.TASK).translate("sterile").build()).m_138386_("give_dog_bandaid", (CriterionTriggerInstance)DogBandaidApplyTrigger.getInstance()).m_138389_(consumer, Util.getResourcePath("default/sterile"));
            Advancement recovered_advancement = Advancement.Builder.m_138353_().m_138398_(bandaid_advancement).m_138358_(DisplayInfoBuilder.create().icon(DTAdvancementProvider.createFullRecoveryBed(false)).frame(FrameType.TASK).translate("a_full_recovery").build()).m_138386_("dog_recovered", (CriterionTriggerInstance)DogRecoveredTrigger.getInstance(false)).m_138389_(consumer, Util.getResourcePath("default/dog_recovered"));
            Advancement best_dogtor_advancement = Advancement.Builder.m_138353_().m_138398_(recovered_advancement).m_138358_(DisplayInfoBuilder.create().icon(DTAdvancementProvider.createFullRecoveryBed(true)).frame(FrameType.TASK).translate("the_best_dogtor").build()).m_138386_("dog_recovered_special", (CriterionTriggerInstance)DogRecoveredTrigger.getInstance(true)).m_138389_(consumer, Util.getResourcePath("default/dog_recovered_special"));
        }
    }
}

