/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DTLootModifierProvider
extends GlobalLootModifierProvider {
    public static final float RICE_FROM_GRASS_DROP_CHANCE = 0.125f;
    public static final float SOY_FROM_ZOMBIE_DROP_CHANCE = 0.01f;
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> CODEC = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"doggytalents");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> RICE_FROM_GRASS_CODEC = CODEC.register("rice_from_grass", RiceFromGrass::getCodec);
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> SOY_FROM_ZOMBIE_CODEC = CODEC.register("soy_from_zombie", SoyFromZombies::getCodec);

    public DTLootModifierProvider(PackOutput output) {
        super(output, "doggytalents");
    }

    protected void start() {
        this.add("rice_from_grass_modifier", (IGlobalLootModifier)this.createGrassRiceModifer());
        this.add("soy_from_zombie_modifier", (IGlobalLootModifier)this.createSoyFromZombiesModifier());
    }

    private RiceFromGrass createGrassRiceModifer() {
        LootItemCondition correct_id_codition = LootTableIdCondition.builder((ResourceLocation)Blocks.f_50034_.m_60589_()).m_6409_();
        LootItemCondition not_shear_condtion = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_})).m_81807_().m_6409_();
        LootItemCondition random_condition = LootItemRandomChanceCondition.m_81927_((float)0.125f).m_6409_();
        LootItemCondition[] conditions = new LootItemCondition[]{correct_id_codition, not_shear_condtion, random_condition};
        return new RiceFromGrass(conditions);
    }

    private SoyFromZombies createSoyFromZombiesModifier() {
        LootItemCondition killed_by_dog_condition = LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)DoggyEntityTypes.DOG.get())).m_6409_();
        LootItemCondition drop_soy_condition = LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_204077_(DoggyTags.DROP_SOY_WHEN_DOG_KILL)).m_6409_();
        LootItemCondition random_condition = LootItemRandomChanceCondition.m_81927_((float)0.01f).m_6409_();
        LootItemCondition[] conditions = new LootItemCondition[]{killed_by_dog_condition, drop_soy_condition, random_condition};
        return new SoyFromZombies(conditions);
    }

    public static class RiceFromGrass
    extends LootModifier {
        private static Codec<LootModifier> CODEC = RecordCodecBuilder.create(x -> RiceFromGrass.codecStart((RecordCodecBuilder.Instance)x).apply((Applicative)x, RiceFromGrass::new));

        public static Codec<LootModifier> getCodec() {
            return CODEC;
        }

        protected RiceFromGrass(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return (Codec)RICE_FROM_GRASS_CODEC.get();
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            generatedLoot.add((Object)new ItemStack((ItemLike)DoggyItems.RICE_GRAINS.get()));
            return generatedLoot;
        }
    }

    public static class SoyFromZombies
    extends LootModifier {
        private static Codec<LootModifier> CODEC = RecordCodecBuilder.create(x -> SoyFromZombies.codecStart((RecordCodecBuilder.Instance)x).apply((Applicative)x, SoyFromZombies::new));

        public static Codec<LootModifier> getCodec() {
            return CODEC;
        }

        protected SoyFromZombies(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return (Codec)SOY_FROM_ZOMBIE_CODEC.get();
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            int r = 1 + context.m_230907_().m_188503_(3);
            generatedLoot.add((Object)new ItemStack((ItemLike)DoggyItems.SOY_BEANS.get(), r));
            return generatedLoot;
        }
    }
}

