/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.feature.DogSize;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.RandomUtil;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ObjectUtils;

public class DogPettingManager {
    private final Dog dog;
    private boolean locked = false;
    private long lastPetTimestamp = 0L;
    private int burn_cooldown = 10;

    public DogPettingManager(Dog dog) {
        this.dog = dog;
    }

    public boolean isPetting() {
        return this.dog.getPettingState().is_petting();
    }

    public UUID getPetterId() {
        return this.dog.getPettingState().petting_id();
    }

    public void setPetting(Player petter, DogPettingType type) {
        if (petter == null || type == null || !this.canPet(petter)) {
            return;
        }
        if (this.isPetting()) {
            return;
        }
        this.dog.setPettingState(new DogPettingState(petter.m_20148_(), true, type));
        petter.f_20883_ = petter.f_20885_;
    }

    public void stopPetting() {
        if (!this.dog.m_9236_().f_46443_) {
            this.lastPetTimestamp = this.dog.m_9236_().m_46468_();
        }
        this.dog.setPettingState(DogPettingState.NULL);
    }

    public long getTimeSinceLastPet() {
        long ret = this.dog.m_9236_().m_46468_() - this.lastPetTimestamp;
        if (ret < 0L) {
            ret = 0L;
        }
        return ret;
    }

    public float getJealousChance() {
        long chance_time_start = 400L;
        long chance_time_end = 6000L;
        float max_chance = 0.2f;
        float min_chance = 0.05f;
        long last_pet_time = this.getTimeSinceLastPet();
        if (last_pet_time <= 400L) {
            return -1.0f;
        }
        long chance_time = last_pet_time - 400L;
        double progress = (double)chance_time / 5600.0;
        progress = Mth.m_14008_((double)progress, (double)0.0, (double)1.0);
        double ret = (double)0.05f + progress * (double)0.15f;
        return (float)ret;
    }

    public void tick() {
        Player petter;
        if (!this.dog.m_9236_().f_46443_ && this.isPetting() && !this.canPet(this.getPetterFromDog())) {
            this.stopPetting();
        }
        if (this.dog.m_9236_().f_46443_ && this.isPetting()) {
            this.playParticleEffect();
        }
        if (!this.dog.m_9236_().f_46443_ && this.isPetting() && this.dog.dogVariant().burnsPetter()) {
            this.mayDoLoveBurns();
        }
        if (this.isPetting() && (petter = this.getPetterFromDog()) != null) {
            petter.f_20883_ = petter.f_20885_;
        }
    }

    public void mayDoLoveBurns() {
        if (--this.burn_cooldown > 0) {
            return;
        }
        RandomSource random = this.dog.m_217043_();
        if (random.m_188503_(100) != 0) {
            return;
        }
        this.burn_cooldown = (7 + random.m_188503_(9)) * 20;
        Player petter = this.getPetterFromDog();
        if (petter == null) {
            return;
        }
        boolean hurt_result = petter.m_6469_(petter.m_269291_().m_269233_(), 0.1f);
        if (hurt_result) {
            petter.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + random.m_188501_() * 0.4f);
            if (this.dog.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.dog.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, petter.m_20185_(), petter.m_20186_(), petter.m_20189_(), random.m_216332_(2, 4), (double)petter.m_20205_(), (double)0.8f, (double)petter.m_20205_(), 0.1);
            }
        }
    }

    public void playParticleEffect() {
        RandomSource random = this.dog.m_217043_();
        if (this.dog.m_217043_().m_188503_(20) == 0) {
            double x = this.dog.m_20185_() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.m_20205_() / 2.0f) + 0.3);
            double y = this.dog.m_20186_() + 0.4 + (double)random.m_188501_() * ((double)this.dog.m_20206_() - 0.4);
            double z = this.dog.m_20189_() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.m_20205_() / 2.0f) + 0.3);
            double dx = random.m_188583_() * 0.02;
            double dy = random.m_188583_() * 0.02;
            double dz = random.m_188583_() * 0.02;
            this.dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, dx, dy, dz);
        }
    }

    public boolean canPet(Player player) {
        if (this.locked) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.dog.m_21805_(), (Object)player.m_20148_())) {
            return false;
        }
        if (!this.isInPetDistance(this.dog, player)) {
            return false;
        }
        if (!this.isSelectingDog(player, this.dog)) {
            return false;
        }
        if (!DogPettingManager.isPlayerAbleToPet(player)) {
            return false;
        }
        return DogPettingManager.isDogAbleToBePet(this.dog);
    }

    public static boolean isPlayerAbleToPet(Player player) {
        ItemStack mainhand_item = player.m_21205_();
        if (mainhand_item != null && !mainhand_item.m_41619_()) {
            return false;
        }
        if (player.m_20160_() || player.m_20159_()) {
            return false;
        }
        if (player.m_5833_()) {
            return false;
        }
        return player.m_6144_();
    }

    public static boolean isDogAbleToBePet(Dog dog) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.m_21825_() || !DogPettingManager.isDogPoseCanPet(dog.getDogPose())) {
            return false;
        }
        if (dog.m_6060_()) {
            return false;
        }
        if (dog.m_20160_() || dog.m_20159_()) {
            return false;
        }
        DogSize size = dog.getDogSize();
        return size.largerOrEquals(DogSize.MODERATO);
    }

    public static boolean isDogPoseCanPet(DogPose dogPose) {
        return dogPose == DogPose.SIT || dogPose == DogPose.REST_BELLY;
    }

    public boolean isInPetDistance(Dog dog, Player player) {
        double max_dist = this.getMaxPetDistance(dog, player);
        if (dog.m_20280_((Entity)player) >= max_dist * max_dist) {
            return false;
        }
        return this.checkEyeDistance(dog, player);
    }

    private double getMaxPetDistance(Dog dog, Player player) {
        float dog_bbw = dog.m_20205_();
        return (double)(dog_bbw / 2.0f + player.m_20205_() / 2.0f) + 0.5;
    }

    private boolean checkEyeDistance(Dog dog, Player player) {
        double dog_eye_y;
        double player_eye_y = player.m_20188_();
        double d_eye_y = player_eye_y - (dog_eye_y = dog.m_20188_());
        return 0.3 <= d_eye_y || d_eye_y <= 0.5;
    }

    private boolean isSelectingDog(Player player, Dog dog) {
        Vec3 eye_pos;
        double pick_range = player.getEntityReach();
        Vec3 view_vec = player.m_20252_(1.0f);
        Vec3 from_vec = eye_pos = player.m_20299_(0.0f);
        Vec3 to_vec = eye_pos.m_82549_(view_vec.m_82490_(pick_range));
        AABB dog_bb = dog.m_20191_();
        boolean hit_dog = dog_bb.m_82371_(from_vec, to_vec).isPresent();
        return hit_dog;
    }

    private Player getPetterFromDog() {
        if (!this.isPetting()) {
            return null;
        }
        UUID pet_uuid = this.getPetterId();
        Player petter = this.dog.m_9236_().m_46003_(pet_uuid);
        return petter;
    }

    public boolean checkPush(Entity source) {
        if (!this.isPetting()) {
            return false;
        }
        Player petting = this.getPetterFromDog();
        if (petting != source) {
            return false;
        }
        float max_go_inside_bb_dist = this.getMinClipDistanceWhenPet();
        if (max_go_inside_bb_dist <= 0.0f) {
            return false;
        }
        return !(petting.m_20280_((Entity)this.dog) < (double)(max_go_inside_bb_dist * max_go_inside_bb_dist));
    }

    private float getMinClipDistanceWhenPet() {
        DogPettingType type = this.dog.getPettingState().type();
        if (type == DogPettingType.BACK_HUG || type == DogPettingType.BELLY_RUB) {
            return 0.7f * this.dog.m_20205_() / 2.0f;
        }
        return -1.0f;
    }

    public void setLocked(boolean lock) {
        this.locked = lock;
    }

    public void save(CompoundTag tag) {
        CompoundTag tag0 = new CompoundTag();
        tag0.m_128356_("dog_last_pet_time", this.lastPetTimestamp);
        tag.m_128365_("dogPettingManager", (Tag)tag0);
    }

    public void load(CompoundTag tag) {
        this.lastPetTimestamp = 0L;
        if (tag.m_128425_("dogPettingManager", 10)) {
            CompoundTag tag0 = tag.m_128469_("dogPettingManager");
            this.lastPetTimestamp = tag0.m_128454_("dog_last_pet_time");
        }
    }

    public record DogPettingState(UUID petting_id, boolean is_petting, DogPettingType type) {
        public static DogPettingState NULL = new DogPettingState(Util.f_137441_, false, DogPettingType.FACERUB);
    }

    public static enum DogPettingType {
        FACERUB(0),
        HUG(1),
        BELLY_RUB(2),
        BACK_HUG(3);

        private final int id;

        private DogPettingType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DogPettingType fromId(int id) {
            DogPettingType[] vals = DogPettingType.values();
            if (id < 0 || id >= vals.length) {
                id = 0;
            }
            return vals[id];
        }
    }
}

