/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTags;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.FoodHandler;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;

public class DogBegGoal
extends Goal {
    private final Dog dog;
    private final float minPlayerDistance;
    private LivingEntity owner;
    private int timeoutCounter;

    public DogBegGoal(Dog wolf, float minDistance) {
        this.dog = wolf;
        this.minPlayerDistance = minDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dog.isDogResting()) {
            return false;
        }
        if (!this.dog.getAnim().freeHead() && this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null) {
            return false;
        }
        if (!owner.m_6084_() || owner.m_5833_()) {
            return false;
        }
        if (owner.m_20280_((Entity)this.dog) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        if (!this.hasTemptationItemInHand(owner)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (!this.owner.m_6084_() || this.owner.m_5833_()) {
            return false;
        }
        if (this.dog.m_20280_((Entity)this.owner) > (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            return false;
        }
        return this.timeoutCounter > 0 && this.hasTemptationItemInHand(this.owner);
    }

    public void m_8056_() {
        this.dog.setBegging(true);
        this.timeoutCounter = 40 + this.dog.m_217043_().m_188503_(40);
    }

    public void m_8041_() {
        this.dog.setBegging(false);
        this.owner = null;
    }

    public void m_8037_() {
        this.dog.m_21563_().m_24950_(this.owner.m_20185_(), this.owner.m_20188_(), this.owner.m_20189_(), 10.0f, (float)this.dog.m_8132_());
        --this.timeoutCounter;
    }

    private boolean hasTemptationItemInHand(LivingEntity player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemstack = player.m_21120_(hand);
            if (itemstack.m_204117_(this.dog.m_21824_() ? DoggyTags.BEG_ITEMS_TAMED : DoggyTags.BEG_ITEMS_UNTAMED)) {
                return true;
            }
            if (itemstack.m_204117_(DoggyTags.TREATS)) {
                return true;
            }
            if (!FoodHandler.isFood(itemstack, this.dog).isPresent()) continue;
            return true;
        }
        return false;
    }
}

