/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogRandomStandIdleGoal
extends Goal {
    private Dog dog;
    private int stopTick;
    private int startTick;
    private boolean jumped;
    private DogAnimation currentAnimation = DogAnimation.NONE;

    public DogRandomStandIdleGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        double use_chance;
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.m_6060_()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        double d = use_chance = this.dog.isChopinTail() ? 0.08 : 0.02;
        if ((double)this.dog.m_217043_().m_188501_() >= use_chance) {
            return false;
        }
        this.currentAnimation = this.getIdleAnim();
        return this.currentAnimation != DogAnimation.NONE;
    }

    public boolean m_8045_() {
        if (!this.dog.m_20096_() && this.currentAnimation != DogAnimation.BACKFLIP) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        return this.dog.f_19797_ < this.stopTick;
    }

    public void m_8056_() {
        this.stopTick = this.dog.f_19797_ + this.currentAnimation.getLengthTicks();
        this.startTick = this.dog.f_19797_;
        this.jumped = false;
        this.dog.setAnimForIdle(this.currentAnimation);
    }

    public void m_8037_() {
        if (this.currentAnimation == DogAnimation.BACKFLIP) {
            this.checkJumpIfBackfilip();
        }
    }

    private void checkJumpIfBackfilip() {
        if (!this.jumped && this.dog.f_19797_ - this.startTick >= 3) {
            this.jumped = true;
            this.dog.m_21569_().m_24901_();
        }
    }

    public void m_8041_() {
        if (this.dog.getAnim() == this.currentAnimation) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private DogAnimation getIdleAnim() {
        float r = this.dog.m_217043_().m_188501_();
        if (this.dog.isChopinTail()) {
            if (r <= 0.1f) {
                return DogAnimation.NONE;
            }
            if (r <= 0.4f) {
                return DogAnimation.BACKFLIP;
            }
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.02f) {
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.08f) {
            return DogAnimation.DIG;
        }
        if (r <= 0.35f) {
            return DogAnimation.STRETCH;
        }
        return DogAnimation.NONE;
    }
}

