/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import net.minecraft.sounds.SoundEvents;

public class DogHowlAction
extends TriggerableAction {
    private int stopTick;
    private int tickTillHowl = 50;

    public DogHowlAction(Dog dog) {
        super(dog, false, false);
    }

    @Override
    public void onStart() {
        this.stopTick = this.dog.f_19797_ + DogAnimation.HOWL.getLengthTicks();
        this.dog.setAnim(DogAnimation.HOWL);
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    @Override
    public void tick() {
        if (this.dog.getAnim() != DogAnimation.HOWL) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.dog.f_19797_ >= this.stopTick) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        --this.tickTillHowl;
        if (this.tickTillHowl == 0) {
            this.dog.dogSoundManager.playInterruptible(SoundEvents.f_12620_, 1.0f, this.dog.m_6100_());
        } else if (this.tickTillHowl == 30) {
            this.dog.m_5496_(SoundEvents.f_12619_, 0.3f, this.dog.m_6100_());
        }
    }

    @Override
    public void onStop() {
        if (this.dog.getAnim() == DogAnimation.HOWL) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        if (this.isStarted()) {
            this.dog.dogSoundManager.setAmbientLocked(false);
            this.dog.dogSoundManager.interuptPlaying();
        }
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }
}

