/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.serializers;

import doggytalents.common.item.DoggyArtifactItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class DoggyArtifactsSerializer
implements EntityDataSerializer<List<DoggyArtifactItem>> {
    public void write(FriendlyByteBuf buf, List<DoggyArtifactItem> value) {
        buf.writeInt(value.size());
        for (DoggyArtifactItem x : value) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)x);
        }
    }

    public List<DoggyArtifactItem> read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<DoggyArtifactItem> list = new ArrayList<DoggyArtifactItem>(size);
        for (int i = 0; i < size; ++i) {
            Item item = (Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            if (!(item instanceof DoggyArtifactItem)) continue;
            DoggyArtifactItem artifactItem = (DoggyArtifactItem)item;
            list.add(artifactItem);
        }
        return list;
    }

    public List<DoggyArtifactItem> copy(List<DoggyArtifactItem> value) {
        ArrayList<DoggyArtifactItem> newInst = new ArrayList<DoggyArtifactItem>(value.size());
        for (DoggyArtifactItem inst : value) {
            newInst.add(inst);
        }
        return newInst;
    }
}

