/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.util.DogUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class DogTalentPacket
extends DogPacket<DogTalentData> {
    @Override
    public void encode(DogTalentData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get(), (Object)data.talent);
    }

    @Override
    public DogTalentData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.readRegistryIdUnsafe(DoggyTalentsAPI.TALENTS.get());
        return new DogTalentData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dogIn, DogTalentData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        if (!DogUtil.playerCanTrainTalent((Player)ctx.get().getSender(), data.talent)) {
            return;
        }
        if (!data.talent.isDogEligible(dogIn)) {
            return;
        }
        int level = dogIn.getDogLevel(data.talent);
        if (level < data.talent.getMaxLevel() && dogIn.canSpendPoints(data.talent.getLevelCost(level + 1))) {
            dogIn.setTalentLevel(data.talent, level + 1);
        }
    }
}

