/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Lists;
import doggytalents.DoggyEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogMode;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.IDogData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DogRespawnData
implements IDogData {
    private final DogRespawnStorage storage;
    private final UUID uuid;
    private UUID ownerUUID;
    private Optional<String> dogName = Optional.empty();
    private CompoundTag data;
    private DogIncapacitatedMananger.IncapacitatedSyncState killedBy = DogIncapacitatedMananger.IncapacitatedSyncState.NONE;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting", "ActiveEffects"});
    private static final List<String> IMPORTANT_TAGS = List.of("Owner", "friendlyFire", "UUID", "talents", "level_normal", "level_kami", "dogGender", "dogSize", "entityKills", "accessories", "doggytalents_dog_skin");
    private static final String STORAGE_AGE_TAG = "DogRespawn_Age";
    private static final String STORAGE_OWNER_TAG = "DogRespawn_ownerUUID";
    private static final String STORAGE_NAME_TAG = "DogRespawn_dogName";

    protected DogRespawnData(DogRespawnStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    public String getDogName() {
        String name = this.dogName.orElse(null);
        return name == null ? "noname" : name;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    public void populate(Dog dogIn) {
        DataStrategy strategy;
        Optional<DamageSource> deathCauseOptional;
        this.data = new CompoundTag();
        this.ownerUUID = dogIn.m_21805_();
        Component customName = dogIn.m_7770_();
        if (customName != null) {
            this.dogName = Optional.ofNullable(customName.getString());
        }
        if ((deathCauseOptional = dogIn.getDogDeathCause()).isPresent()) {
            this.killedBy = dogIn.createIncapSyncState(deathCauseOptional.get());
        }
        if ((strategy = this.fetchDataStrategy()) == DataStrategy.KEEP_ALL_EXCEPT) {
            this.writeAlldataAndRemoveSpecific(dogIn, this.data);
        } else {
            this.writeImportantDataToKeep(dogIn, this.data);
        }
        this.data.m_128473_("UUID");
        this.data.m_128473_("LoveCause");
        this.data.m_128473_("DTN_DupeDetect");
    }

    private void writeAlldataAndRemoveSpecific(Dog dog, CompoundTag target) {
        dog.m_20240_(target);
        for (String tag : TAGS_TO_REMOVE) {
            target.m_128473_(tag);
        }
        target.m_128473_(STORAGE_AGE_TAG);
        target.m_128473_(STORAGE_OWNER_TAG);
        target.m_128473_(STORAGE_NAME_TAG);
        try {
            List extraTagsToRemove = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_REMOVE.get();
            for (String tag : extraTagsToRemove) {
                if (IMPORTANT_TAGS.contains(tag)) continue;
                target.m_128473_(tag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeImportantDataToKeep(Dog dog, CompoundTag target) {
        Component custom_name;
        dog.addDTNAdditionalSavedData(target);
        target.m_128405_(STORAGE_AGE_TAG, dog.m_146764_());
        UUID owner_uuid = dog.m_21805_();
        if (owner_uuid != null) {
            target.m_128362_(STORAGE_OWNER_TAG, owner_uuid);
        }
        if ((custom_name = dog.m_7770_()) != null) {
            target.m_128359_(STORAGE_NAME_TAG, Component.Serializer.m_130703_((Component)custom_name));
        }
        this.keepAdditionalTag(target, dog);
    }

    private void keepAdditionalTag(CompoundTag target, Dog dog) {
        try {
            List extraTagsToKeep = (List)ConfigHandler.RESPAWN_TAGS.TAGS_TO_KEEP.get();
            if (extraTagsToKeep == null || extraTagsToKeep.isEmpty()) {
                return;
            }
            CompoundTag nonDTNTags = new CompoundTag();
            dog.addNonDTNAdditionalData(nonDTNTags);
            for (String toKeepStr : extraTagsToKeep) {
                if (!nonDTNTags.m_128441_(toKeepStr) || target.m_128441_(toKeepStr)) continue;
                Tag toKeep = nonDTNTags.m_128423_(toKeepStr).m_6426_();
                target.m_128365_(toKeepStr, toKeep);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreAndConsumeImportantDataIfNeeded(Dog dog, CompoundTag tag) {
        if (tag.m_128425_(STORAGE_AGE_TAG, 3)) {
            dog.m_146762_(tag.m_128451_(STORAGE_AGE_TAG));
            tag.m_128473_(STORAGE_AGE_TAG);
        }
        if (tag.m_128403_(STORAGE_OWNER_TAG)) {
            UUID correct_owner_uuid = this.ownerUUID;
            try {
                correct_owner_uuid = tag.m_128342_(STORAGE_OWNER_TAG);
            }
            catch (Exception exception) {
                // empty catch block
            }
            dog.m_21816_(correct_owner_uuid);
            dog.m_7105_(correct_owner_uuid != null);
            tag.m_128473_(STORAGE_OWNER_TAG);
        }
        if (tag.m_128441_(STORAGE_NAME_TAG)) {
            try {
                String name_c1_str = tag.m_128461_(STORAGE_NAME_TAG);
                dog.setDogCustomName((Component)Component.Serializer.m_130701_((String)name_c1_str));
            }
            catch (Exception exception) {
                // empty catch block
            }
            tag.m_128473_(STORAGE_NAME_TAG);
        }
    }

    @Nullable
    public Dog respawn(ServerLevel worldIn, Player playerIn, BlockPos pos) {
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_((Level)worldIn);
        if (dog == null) {
            return null;
        }
        dog.m_20219_(Vec3.m_82539_((Vec3i)pos));
        this.restoreAndConsumeImportantDataIfNeeded(dog, this.data);
        CompoundTag compoundnbt = dog.m_20240_(new CompoundTag());
        UUID uuid = dog.m_20148_();
        compoundnbt.m_128391_(this.data);
        dog.m_20258_(compoundnbt);
        boolean useOldUUID = (Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get() == false && worldIn.m_8791_(this.uuid) == null;
        dog.m_20084_(useOldUUID ? this.uuid : uuid);
        dog.m_21839_(true);
        if (this.killedBy != null && this.killedBy != DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            if (dog.getDogIncapValue() <= 0) {
                dog.setDogIncapValue(dog.getDefaultInitIncapVal());
            }
            dog.setDogHunger(0.0f);
            dog.setMode(DogMode.INJURED);
            dog.m_21153_(1.0f);
            dog.setIncapSyncState(this.killedBy);
            if (dog.m_20069_() || dog.m_20077_()) {
                dog.triggerAnimationAction(new DogDrownAction(dog));
            } else {
                dog.setAnim(dog.incapacitatedMananger.getAnim());
            }
        } else {
            dog.setMode(DogMode.DOCILE);
            dog.setAnim(DogAnimation.STAND_QUICK);
            dog.maxHealth();
        }
        DogDuplicationDetection.onAboutToRespawn(dog);
        worldIn.m_47205_((Entity)dog);
        DogLocationStorage.setSessionUUIDFor(dog, uuid);
        return dog;
    }

    public void read(CompoundTag compound) {
        this.data = compound.m_128469_("data");
        if (compound.m_128425_("dog_name", 8)) {
            try {
                String name_str = compound.m_128461_("dog_name");
                this.dogName = Optional.ofNullable(name_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compound.m_128403_("owner_uuid")) {
            this.ownerUUID = compound.m_128342_("owner_uuid");
        }
        this.readKilledBy(compound);
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128365_("data", (Tag)this.data);
        if (this.dogName.isPresent()) {
            compound.m_128359_("dog_name", this.dogName.get());
        }
        if (this.ownerUUID != null) {
            compound.m_128362_("owner_uuid", this.ownerUUID);
        }
        this.writeKilledBy(compound);
        return compound;
    }

    public void writeKilledBy(CompoundTag compound) {
        if (this.killedBy == DogIncapacitatedMananger.IncapacitatedSyncState.NONE) {
            return;
        }
        if (this.killedBy == null) {
            return;
        }
        CompoundTag killedByTag = new CompoundTag();
        killedByTag.m_128405_("typeId", this.killedBy.type.getId());
        killedByTag.m_128405_("poseId", this.killedBy.poseId);
        compound.m_128365_("dog_killed_by", (Tag)killedByTag);
    }

    public void readKilledBy(CompoundTag compound) {
        if (!compound.m_128425_("dog_killed_by", 10)) {
            return;
        }
        CompoundTag killedByTag = compound.m_128469_("dog_killed_by");
        int typeId = killedByTag.m_128451_("typeId");
        int poseId = killedByTag.m_128451_("poseId");
        this.killedBy = new DogIncapacitatedMananger.IncapacitatedSyncState(DogIncapacitatedMananger.DefeatedType.byId(typeId), DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private DataStrategy fetchDataStrategy() {
        Integer stategy_int = (Integer)ConfigHandler.RespawnTagConfig.getConfig(ConfigHandler.RESPAWN_TAGS.STRATEGY);
        if (stategy_int != 1) {
            return DataStrategy.REMOVE_ALL_EXCEPT;
        }
        return DataStrategy.KEEP_ALL_EXCEPT;
    }

    private static enum DataStrategy {
        REMOVE_ALL_EXCEPT,
        KEEP_ALL_EXCEPT;

    }
}

