/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.util.DogUtil;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class BedDogTalent
extends TalentInstance {
    private long cooldownDealine = 0L;

    public BedDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    public void onSuccessfulSleep(AbstractDog dog) {
        float base_threshold;
        Level level = dog.m_9236_();
        this.cooldownDealine = level.m_46468_() + (long)this.getCooldownTicks();
        float set_hunger = dog.getDogHunger();
        if (set_hunger > (base_threshold = (float)this.getBaseMinHungerForSleep()) && (set_hunger -= (float)this.getHungerCostPerSleep()) < base_threshold) {
            set_hunger = base_threshold;
        }
        dog.setDogHunger(set_hunger);
    }

    public boolean isOnCooldown(AbstractDog dog) {
        Level level = dog.m_9236_();
        return level.m_46468_() < this.cooldownDealine;
    }

    public int getCooldownDaysLeft(AbstractDog dog) {
        Level level = dog.m_9236_();
        long time_till = this.cooldownDealine - level.m_46468_();
        if (time_till <= 0L) {
            return 0;
        }
        return Mth.m_14167_((float)((float)time_till / 24000.0f));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldownDealine = compound.m_128454_("cooldown_end");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128356_("cooldown_end", this.cooldownDealine);
    }

    @Override
    public boolean allowDetrain(AbstractDog dog) {
        return !this.isOnCooldown(dog);
    }

    public static void useBedDog(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.getDogLevel(DoggyTalents.BED_DOG) <= 0) {
            return;
        }
        DogSleepOnManager.StartSleepOnDogResult result = DogSleepOnManager.getServer(level.m_7654_()).setOrRequestSleepOn(dog, player);
        BedDogTalent.proccessResult(result, dog, player);
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.NO_POS)) {
            player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 10);
        }
    }

    private static void proccessResult(DogSleepOnManager.StartSleepOnDogResult result, Dog dog, Player player) {
        if (result.ok() || result.other()) {
            return;
        }
        if (result.isFailMsg(DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN)) {
            BedDogTalent.sendCooldownMsg(dog, player);
            return;
        }
        player.m_213846_(result.failMsg().getMsg(dog));
    }

    private static void sendCooldownMsg(Dog dog, Player player) {
        Optional<BedDogTalent> inst_optional = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst_optional.isPresent()) {
            return;
        }
        BedDogTalent inst = inst_optional.get();
        player.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.bed_dog.fail.cooldown", (Object[])new Object[]{dog.m_7755_().getString(), Integer.toString(inst.getCooldownDaysLeft(dog))}));
    }

    public static DogSleepOnManager.StartSleepOnDogResult isSleepCondition(Dog dog, BedDogTalent inst) {
        if (dog.getDogHunger() < (float)inst.getMinHungerForSleep()) {
            return DogSleepOnManager.DogSleepOnFailMessage.DOG_LOW_HUNGER.asResult();
        }
        if (inst.isOnCooldown(dog)) {
            return DogSleepOnManager.DogSleepOnFailMessage.COOLDOWN.asResult();
        }
        return DogSleepOnManager.StartSleepOnDogResult.OK;
    }

    public int getHungerCostPerSleep() {
        int level = this.level();
        if (level <= 3) {
            return 40;
        }
        if (level == 4) {
            return 30;
        }
        return 0;
    }

    public int getMinHungerForSleep() {
        return this.getHungerCostPerSleep() + this.getBaseMinHungerForSleep();
    }

    public int getBaseMinHungerForSleep() {
        return 20;
    }

    public int getCooldownTicks() {
        int level = this.level();
        if (level <= 3) {
            return 72000;
        }
        if (level == 4) {
            return 48000;
        }
        return 0;
    }
}

