/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;

public class CreeperSweeperTalent
extends TalentInstance {
    private int cooldown;
    private boolean onlyAttackCreeper = false;

    public CreeperSweeperTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.f_19797_;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() > 0) {
            List list;
            if (this.canAttackCreeper() && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_CREEPER_SWEEPER_DONT_GROWL)).booleanValue()) {
                return;
            }
            int timeLeft = this.cooldown - dog.f_19797_;
            if (!(timeLeft > 0 || dog.m_21825_() && !dog.m_20159_() || (list = dog.m_9236_().m_45976_(Creeper.class, dog.m_20191_().m_82377_((double)this.getSearchRange(dog), (double)(this.level() * 2), (double)this.getSearchRange(dog)))).isEmpty())) {
                dog.m_5496_(((Dog)dog).dogMood.getSeriousGrowl(), dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
                this.cooldown = dog.f_19797_ + 60 + dog.m_217043_().m_188503_(40);
            }
        }
    }

    private int getSearchRange(AbstractDog dog) {
        if (dog instanceof Dog) {
            Dog d = (Dog)dog;
            if (d.isMode(DogMode.GUARD, DogMode.GUARD_FLAT, DogMode.GUARD_MINOR)) {
                return Math.min(this.level() * 5, 8);
            }
        }
        return this.level() * 5;
    }

    @Override
    public InteractionResult canAttack(AbstractDog dog, LivingEntity entity) {
        if (this.canAttackCreeper() && this.onlyAttackCreeper) {
            return entity instanceof Creeper ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return entity instanceof Creeper && this.canAttackCreeper() ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public InteractionResult shouldAttackEntity(AbstractDog dog, LivingEntity target, LivingEntity owner) {
        if (this.canAttackCreeper() && this.onlyAttackCreeper) {
            return target instanceof Creeper ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return target instanceof Creeper && this.canAttackCreeper() ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean canAttackCreeper() {
        return this.level() >= 5;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
        if (!this.canAttackCreeper()) {
            return;
        }
        if (!(target instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)target;
        creeper.m_21153_(0.0f);
        creeper.m_6667_(dogIn.m_269291_().m_269333_((LivingEntity)dogIn));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.onlyAttackCreeper = compound.m_128471_("targetOnlyCreeper");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("targetOnlyCreeper", this.onlyAttackCreeper);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            return this.onlyAttackCreeper;
        }
        return null;
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.CREEPER_SWEEPER_EXC.get());
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            this.onlyAttackCreeper = (Boolean)data;
        }
    }

    public boolean onlyAttackCreeper() {
        return this.onlyAttackCreeper;
    }

    public void setOnlyAttackCreeper(boolean val) {
        this.onlyAttackCreeper = val;
    }
}

